<?php

namespace _121Digital\Connect\User;

use _121Digital\Connect\Core\Plugin;

class UserRoles
{
    public const REG121_USER = 'reg121_user';

    public function register(): void
    {
        add_action('init', [$this, 'addCustomRoles']);
    }

    public function addCustomRoles(): void
    {
        // flush the existing role and create the new one...
        remove_role('reg121_user');
        add_role(
            self::REG121_USER,
            __('REG121 User', '121-connect'),
            [
              'read' => true,
              'edit_posts' => true,
              'edit_pages' => true,
              'edit_others_posts' => true,
              'edit_published_posts' => true,
              'edit_others_pages' => true,
              'edit_published_pages' => true,
              'publish_posts' => true,
              'publish_pages' => true,
              'delete_posts' => true,
              'delete_pages' => true,
              'delete_published_posts' => true,
              'delete_published_pages' => true,
              'delete_others_posts' => true,
              'delete_others_pages' => true,
              'upload_files' => true, // Media Library
              'read_private_pages' => true,
              'read_private_posts' => true,

              // Elementor-related permissions
              'edit_elementor_templates' => true,
              'delete_elementor_templates' => true,
              'publish_elementor_templates' => true,
              'edit_published_elementor_templates' => true,
              'delete_published_elementor_templates' => true,
              'edit_others_elementor_templates' => true,
              'delete_others_elementor_templates' => true,
              'manage_options' => true,
              'edit_theme_options' => true, // Required for Elementor Settings

              // Yoast SEO permissions
              'wpseo_manage_options' => true,           // Main Yoast SEO management capability
              'wpseo_edit_advanced_metadata' => true,   // Edit advanced metadata
              'wpseo_bulk_edit' => true,                // Bulk edit SEO data
              'manage_categories' => true,              // Often required for taxonomy SEO
              'unfiltered_html' => true,               // May be needed for certain SEO fields
            ]
        );
    }

    /**
     * Check if the current user has the 'reg121_user' role.
     * @return bool
     * @throws \Exception
     */
    public static function isContextUser(): bool
    {
        try {
            return current_user_can('reg121_user');
        } catch (\Exception $e) {
            Plugin::die($e->getMessage());
        }
    }

    /**
     * Check if the current user has the 'administrator' role.
     * @return bool
     * @throws \Exception
     */
    public static function isContextAdministrator(): bool
    {
        try {
            return current_user_can('administrator');
        } catch (\Exception $e) {
            Plugin::die($e->getMessage());
        }
    }
}
