<?php if (!defined('ABSPATH')) {
    exit;
} ?>

<div class="wrap">
  <h1 class="wp-heading-inline">
    <span class="dashicons dashicons-admin-multisite" style="font-size: 28px; vertical-align: middle; margin-right: 8px;"></span>
    <?php echo esc_html($siteName); ?>
  </h1>
  
  <hr class="wp-header-end">

  <?php if (!empty($successMessage)): ?>
  <div id="message" class="updated notice is-dismissible">
    <p><?php echo esc_html($successMessage); ?></p>
  </div>
  <?php endif; ?>

  <?php if (!empty($errorMessage)): ?>
  <div id="message" class="error notice is-dismissible">
    <p><?php echo esc_html($errorMessage); ?></p>
  </div>
  <?php endif; ?>

  <form method="post" action=""><?php wp_nonce_field('update_site_action_' . $siteId, 'update_site_nonce'); ?>

  <!-- Site Actions -->
  <div class="site-actions-bar" style="margin: 20px 0; display: flex; gap: 10px; flex-wrap: wrap; align-items: center;">
    <button type="submit" class="button button-primary">
      <span class="dashicons dashicons-saved" style="vertical-align: middle; margin-right: 5px;"></span>
      <?php esc_html_e('Save Changes', '121-connect'); ?>
    </button>
    <a href="<?php echo esc_url($siteUrl); ?>" class="button button-secondary" target="_blank">
      <span class="dashicons dashicons-admin-site" style="vertical-align: middle; margin-right: 5px;"></span>
      <?php esc_html_e('Visit Site', '121-connect'); ?>
    </a>
    <a href="<?php echo esc_url($siteAdminUrl); ?>" class="button" target="_blank">
      <span class="dashicons dashicons-dashboard" style="vertical-align: middle; margin-right: 5px;"></span>
      <?php esc_html_e('Dashboard', '121-connect'); ?>
    </a>
    <a href="<?php echo esc_url(network_admin_url('sites.php')); ?>" class="button">
      <span class="dashicons dashicons-arrow-left-alt2" style="vertical-align: middle; margin-right: 5px;"></span>
      <?php esc_html_e('Back to Sites', '121-connect'); ?>
    </a>
    
    <!-- Site Status Badge -->
    <div style="margin-left: auto; display: flex; align-items: center; gap: 10px;">
      <?php
        $statusBadges = [];

if ($siteDetails->archived == '1') {
    $statusBadges[] = '<span class="status-badge status-archived"><span class="dashicons dashicons-archive"></span> ' . esc_html__('Archived', '121-connect') . '</span>';
}
if ($siteDetails->spam == '1') {
    $statusBadges[] = '<span class="status-badge status-spam"><span class="dashicons dashicons-warning"></span> ' . esc_html__('Spam', '121-connect') . '</span>';
}
if ($siteDetails->deleted == '1') {
    $statusBadges[] = '<span class="status-badge status-deleted"><span class="dashicons dashicons-trash"></span> ' . esc_html__('Deleted', '121-connect') . '</span>';
}
if ($publicSetting == '-1' || $publicSetting == '-2') {
    $statusBadges[] = '<span class="status-badge status-private"><span class="dashicons dashicons-lock"></span> ' . esc_html__('Private', '121-connect') . '</span>';
}

if (empty($statusBadges)) {
    echo '<span class="status-badge status-active"><span class="dashicons dashicons-yes-alt"></span> ' . esc_html__('Active', '121-connect') . '</span>';
} else {
    echo implode('', $statusBadges);
}
?>
    </div>
  </div>

  <!-- Statistics Cards Row -->
  <div class="stats-cards-container">
    <div class="stats-card">
      <div class="stats-card-icon stats-icon-posts">
        <span class="dashicons dashicons-edit-large"></span>
      </div>
      <div class="stats-card-content">
        <div class="stats-card-number"><?php echo esc_html(number_format_i18n(isset($postCounts->publish) ? $postCounts->publish : 0)); ?></div>
        <div class="stats-card-label"><?php esc_html_e('Posts', '121-connect'); ?></div>
        <?php if (isset($postCounts->publish) && $postCounts->publish > 0): ?>
          <a href="<?php echo esc_url($siteAdminUrl . 'edit.php'); ?>" class="stats-card-link" target="_blank">
            <?php esc_html_e('View Posts', '121-connect'); ?> →
          </a>
        <?php endif; ?>
      </div>
    </div>

    <div class="stats-card">
      <div class="stats-card-icon stats-icon-pages">
        <span class="dashicons dashicons-admin-page"></span>
      </div>
      <div class="stats-card-content">
        <div class="stats-card-number"><?php echo esc_html(number_format_i18n(isset($pageCounts->publish) ? $pageCounts->publish : 0)); ?></div>
        <div class="stats-card-label"><?php esc_html_e('Pages', '121-connect'); ?></div>
        <?php if (isset($pageCounts->publish) && $pageCounts->publish > 0): ?>
          <a href="<?php echo esc_url($siteAdminUrl . 'edit.php?post_type=page'); ?>" class="stats-card-link" target="_blank">
            <?php esc_html_e('View Pages', '121-connect'); ?> →
          </a>
        <?php endif; ?>
      </div>
    </div>

    <div class="stats-card">
      <div class="stats-card-icon stats-icon-plugins">
        <span class="dashicons dashicons-admin-plugins"></span>
      </div>
      <div class="stats-card-content">
        <div class="stats-card-number"><?php echo esc_html(number_format_i18n($pluginCount)); ?></div>
        <div class="stats-card-label"><?php esc_html_e('Plugins', '121-connect'); ?></div>
        <?php if ($pluginCount > 0): ?>
          <a href="<?php echo esc_url($siteAdminUrl . 'plugins.php'); ?>" class="stats-card-link" target="_blank">
            <?php esc_html_e('Manage Plugins', '121-connect'); ?> →
          </a>
        <?php endif; ?>
      </div>
    </div>

    <div class="stats-card">
      <div class="stats-card-icon stats-icon-users">
        <span class="dashicons dashicons-admin-users"></span>
      </div>
      <div class="stats-card-content">
        <div class="stats-card-number"><?php echo esc_html(number_format_i18n(count($siteUsers))); ?></div>
        <div class="stats-card-label"><?php esc_html_e('Users', '121-connect'); ?></div>
        <?php if (!empty($siteUsers)): ?>
          <a href="<?php echo esc_url($siteAdminUrl . 'users.php'); ?>" class="stats-card-link" target="_blank">
            <?php esc_html_e('Manage Users', '121-connect'); ?> →
          </a>
        <?php endif; ?>
      </div>
    </div>
  </div>

  <!-- Main Content Grid -->
  <div class="site-info-grid">
    <!-- Left Column -->
    <div class="site-info-column">
      
      <!-- Site Information -->
      <div class="postbox">
        <div class="postbox-header">
          <h2 class="hndle">
            <span class="dashicons dashicons-info-outline" style="margin-right: 8px;"></span>
            <?php esc_html_e('Site Information', '121-connect'); ?>
          </h2>
        </div>
        <div class="inside">
          <table class="form-table" role="presentation">
            <tbody>
              <tr>
                <th scope="row">
                  <span class="dashicons dashicons-id-alt" style="color: #2271b1; margin-right: 5px;"></span>
                  <?php esc_html_e('Site ID', '121-connect'); ?>
                </th>
                <td><strong><?php echo esc_html($siteId); ?></strong></td>
              </tr>
              <tr>
                <th scope="row">
                  <label for="site_name">
                    <span class="dashicons dashicons-admin-site-alt3" style="color: #2271b1; margin-right: 5px;"></span>
                    <?php esc_html_e('Site Name', '121-connect'); ?>
                  </label>
                </th>
                <td>
                  <input type="text" 
                         name="site_name" 
                         id="site_name" 
                         value="<?php echo esc_attr($siteName); ?>" 
                         class="regular-text" 
                         required />
                </td>
              </tr>
              <tr>
                <th scope="row">
                  <span class="dashicons dashicons-admin-site-alt3" style="color: #2271b1; margin-right: 5px;"></span>
                  <?php esc_html_e('Site URL', '121-connect'); ?>
                </th>
                <td>
                  <a href="<?php echo esc_url($siteUrl); ?>" target="_blank" class="site-link">
                    <?php echo esc_html($siteUrl); ?>
                    <span class="dashicons dashicons-external" style="font-size: 14px; margin-left: 5px;"></span>
                  </a>
                  <p class="description"><?php esc_html_e('URL cannot be changed here.', '121-connect'); ?></p>
                </td>
              </tr>
              <tr>
                <th scope="row">
                  <span class="dashicons dashicons-networking" style="color: #2271b1; margin-right: 5px;"></span>
                  <?php esc_html_e('Domain', '121-connect'); ?>
                </th>
                <td>
                  <code><?php echo esc_html($siteDetails->domain); ?></code>
                  <p class="description"><?php esc_html_e('Domain cannot be changed here.', '121-connect'); ?></p>
                </td>
              </tr>
              <tr>
                <th scope="row">
                  <span class="dashicons dashicons-media-code" style="color: #2271b1; margin-right: 5px;"></span>
                  <?php esc_html_e('Path', '121-connect'); ?>
                </th>
                <td>
                  <code><?php echo esc_html($siteDetails->path); ?></code>
                  <p class="description"><?php esc_html_e('Path cannot be changed here.', '121-connect'); ?></p>
                </td>
              </tr>
              <tr>
                <th scope="row">
                  <label for="admin_email">
                    <span class="dashicons dashicons-email" style="color: #2271b1; margin-right: 5px;"></span>
                    <?php esc_html_e('Admin Email', '121-connect'); ?>
                  </label>
                </th>
                <td>
                  <input type="email" 
                         name="admin_email" 
                         id="admin_email" 
                         value="<?php echo esc_attr($siteAdminEmail); ?>" 
                         class="regular-text" 
                         required />
                </td>
              </tr>
              <tr>
                <th scope="row">
                  <label for="site_description">
                    <span class="dashicons dashicons-text-page" style="color: #2271b1; margin-right: 5px;"></span>
                    <?php esc_html_e('Description', '121-connect'); ?>
                  </label>
                </th>
                <td>
                  <textarea name="site_description" 
                            id="site_description" 
                            class="large-text" 
                            rows="3"><?php echo esc_textarea($siteDescription); ?></textarea>
                  <p class="description"><?php esc_html_e('A brief description of the site.', '121-connect'); ?></p>
                </td>
              </tr>
            </tbody>
          </table>
        </div>
      </div>

      <!-- Configuration -->
      <div class="postbox">
        <div class="postbox-header">
          <h2 class="hndle">
            <span class="dashicons dashicons-admin-settings" style="margin-right: 8px;"></span>
            <?php esc_html_e('Configuration', '121-connect'); ?>
          </h2>
        </div>
        <div class="inside">
          <table class="form-table" role="presentation">
            <tbody>
              <tr>
                <th scope="row">
                  <span class="dashicons dashicons-admin-appearance" style="color: #2271b1; margin-right: 5px;"></span>
                  <?php esc_html_e('Active Theme', '121-connect'); ?>
                </th>
                <td>
                  <strong><?php echo esc_html($themeName); ?></strong>
                  <p class="description"><?php esc_html_e('Theme cannot be changed here. Visit the site dashboard to change theme.', '121-connect'); ?></p>
                </td>
              </tr>
              <tr>
                <th scope="row">
                  <label for="language">
                    <span class="dashicons dashicons-translation" style="color: #2271b1; margin-right: 5px;"></span>
                    <?php esc_html_e('Language', '121-connect'); ?>
                  </label>
                </th>
                <td>
                  <input type="text" 
                         name="language" 
                         id="language" 
                         value="<?php echo esc_attr($siteLanguage); ?>" 
                         class="regular-text" 
                         placeholder="en_US" />
                  <p class="description"><?php esc_html_e('Site language code (e.g., en_US, es_ES). Leave empty for English (United States).', '121-connect'); ?></p>
                </td>
              </tr>
              <tr>
                <th scope="row">
                  <label for="visibility">
                    <span class="dashicons dashicons-visibility" style="color: #2271b1; margin-right: 5px;"></span>
                    <?php esc_html_e('Visibility', '121-connect'); ?>
                  </label>
                </th>
                <td>
                  <select name="visibility" id="visibility" class="regular-text">
                    <option value="1" <?php selected($publicSetting, '1'); ?>>
                      <?php esc_html_e('Public - Allow search engines to index this site', '121-connect'); ?>
                    </option>
                    <option value="0" <?php selected($publicSetting, '0'); ?>>
                      <?php esc_html_e('Public - Discourage search engines from indexing this site', '121-connect'); ?>
                    </option>
                    <option value="-1" <?php selected($publicSetting, '-1'); ?>>
                      <?php esc_html_e('Private - Only network administrators can visit', '121-connect'); ?>
                    </option>
                    <option value="-2" <?php selected($publicSetting, '-2'); ?>>
                      <?php esc_html_e('Private - Only site administrators and users can visit', '121-connect'); ?>
                    </option>
                  </select>
                  <p class="description"><?php esc_html_e('Control who can access this site and whether search engines can index it.', '121-connect'); ?></p>
                </td>
              </tr>
            </tbody>
          </table>
        </div>
      </div>

      <!-- Site Attributes -->
      <div class="postbox">
        <div class="postbox-header">
          <h2 class="hndle">
            <span class="dashicons dashicons-admin-generic" style="margin-right: 8px;"></span>
            <?php esc_html_e('Site Attributes', '121-connect'); ?>
          </h2>
        </div>
        <div class="inside">
          <table class="form-table" role="presentation">
            <tbody>
              <tr>
                <th scope="row">
                  <span class="dashicons dashicons-flag" style="color: #2271b1; margin-right: 5px;"></span>
                  <?php esc_html_e('Status Flags', '121-connect'); ?>
                </th>
                <td>
                  <fieldset>
                    <label for="archived">
                      <input type="checkbox" 
                             name="archived" 
                             id="archived" 
                             value="1" 
                             <?php checked($siteDetails->archived, '1'); ?> />
                      <span><?php esc_html_e('Archived', '121-connect'); ?></span>
                    </label>
                    <p class="description"><?php esc_html_e('Archived sites are not accessible to regular users.', '121-connect'); ?></p>
                    
                    <br />
                    
                    <label for="spam">
                      <input type="checkbox" 
                             name="spam" 
                             id="spam" 
                             value="1" 
                             <?php checked($siteDetails->spam, '1'); ?> />
                      <span><?php esc_html_e('Spam', '121-connect'); ?></span>
                    </label>
                    <p class="description"><?php esc_html_e('Mark this site as spam.', '121-connect'); ?></p>
                    
                    <br />
                    
                    <label for="deleted">
                      <input type="checkbox" 
                             name="deleted" 
                             id="deleted" 
                             value="1" 
                             <?php checked($siteDetails->deleted, '1'); ?> />
                      <span><?php esc_html_e('Deleted', '121-connect'); ?></span>
                    </label>
                    <p class="description"><?php esc_html_e('Mark this site as deleted (will be hidden from normal views).', '121-connect'); ?></p>
                    
                    <br />
                    
                    <label for="mature">
                      <input type="checkbox" 
                             name="mature" 
                             id="mature" 
                             value="1" 
                             <?php checked($siteDetails->mature, '1'); ?> />
                      <span><?php esc_html_e('Mature', '121-connect'); ?></span>
                    </label>
                    <p class="description"><?php esc_html_e('Mark this site as containing mature content.', '121-connect'); ?></p>
                  </fieldset>
                </td>
              </tr>
            </tbody>
          </table>
        </div>
      </div>

    </div>

    <!-- Right Column -->
    <div class="site-info-column">
      
      <!-- Timeline -->
      <div class="postbox">
        <div class="postbox-header">
          <h2 class="hndle">
            <span class="dashicons dashicons-calendar-alt" style="margin-right: 8px;"></span>
            <?php esc_html_e('Timeline', '121-connect'); ?>
          </h2>
        </div>
        <div class="inside">
          <div class="timeline-item">
            <div class="timeline-icon timeline-icon-created">
              <span class="dashicons dashicons-plus-alt"></span>
            </div>
            <div class="timeline-content">
              <div class="timeline-label"><?php esc_html_e('Created', '121-connect'); ?></div>
              <div class="timeline-date"><?php echo esc_html($registeredDate); ?></div>
            </div>
          </div>
          <div class="timeline-item">
            <div class="timeline-icon timeline-icon-updated">
              <span class="dashicons dashicons-update"></span>
            </div>
            <div class="timeline-content">
              <div class="timeline-label"><?php esc_html_e('Last Updated', '121-connect'); ?></div>
              <div class="timeline-date"><?php echo esc_html($lastUpdated); ?></div>
            </div>
          </div>
        </div>
      </div>

      <!-- Site Users -->
      <?php if (!empty($siteUsers)): ?>
      <div class="postbox">
        <div class="postbox-header">
          <h2 class="hndle">
            <span class="dashicons dashicons-groups" style="margin-right: 8px;"></span>
            <?php esc_html_e('Site Users', '121-connect'); ?>
            <span class="user-count-badge"><?php echo esc_html(count($siteUsers)); ?></span>
          </h2>
        </div>
        <div class="inside" style="padding: 0;">
          <div class="users-list">
            <?php
      $maxDisplay = 8;
          $displayUsers = array_slice($siteUsers, 0, $maxDisplay);
          foreach ($displayUsers as $user):
              ?>
            <div class="user-item">
              <div class="user-avatar">
                <?php echo get_avatar($user->ID, 32); ?>
              </div>
              <div class="user-details">
                <div class="user-name">
                  <a href="<?php echo esc_url(network_admin_url('user-edit.php?user_id=' . $user->ID)); ?>">
                    <?php echo esc_html($user->display_name); ?>
                  </a>
                </div>
                <div class="user-email">
                  <a href="mailto:<?php echo esc_attr($user->user_email); ?>">
                    <?php echo esc_html($user->user_email); ?>
                  </a>
                </div>
              </div>
            </div>
            <?php endforeach; ?>
          </div>
          
          <?php if (count($siteUsers) > $maxDisplay): ?>
          <div class="users-footer">
            <a href="<?php echo esc_url($siteAdminUrl . 'users.php'); ?>" class="view-all-link" target="_blank">
              <?php echo sprintf(esc_html__('View all %s users', '121-connect'), number_format_i18n(count($siteUsers))); ?>
              <span class="dashicons dashicons-arrow-right-alt2"></span>
            </a>
          </div>
          <?php endif; ?>
        </div>
      </div>
      <?php endif; ?>

    </div>
  </div>

  </form>

</div>

<style>
/* Status Badges */
.status-badge {
  display: inline-flex;
  align-items: center;
  gap: 5px;
  padding: 6px 12px;
  border-radius: 4px;
  font-size: 13px;
  font-weight: 600;
  white-space: nowrap;
}

.status-badge .dashicons {
  font-size: 16px;
  width: 16px;
  height: 16px;
}

.status-active {
  background: #d5f2e3;
  color: #00a32a;
}

.status-archived,
.status-spam,
.status-deleted,
.status-private {
  background: #ffd4d4;
  color: #d63638;
}

/* Stats Cards */
.stats-cards-container {
  display: grid;
  grid-template-columns: repeat(auto-fit, minmax(220px, 1fr));
  gap: 20px;
  margin: 20px 0 30px 0;
}

.stats-card {
  background: #fff;
  border: 1px solid #dcdcde;
  border-radius: 4px;
  padding: 20px;
  display: flex;
  align-items: flex-start;
  gap: 15px;
  transition: all 0.2s ease;
  box-shadow: 0 1px 1px rgba(0,0,0,.04);
}

.stats-card:hover {
  border-color: #2271b1;
  box-shadow: 0 2px 8px rgba(0,0,0,.1);
  transform: translateY(-2px);
}

.stats-card-icon {
  width: 48px;
  height: 48px;
  border-radius: 8px;
  display: flex;
  align-items: center;
  justify-content: center;
  flex-shrink: 0;
}

.stats-card-icon .dashicons {
  font-size: 24px;
  width: 24px;
  height: 24px;
  color: #fff;
}

.stats-icon-posts {
  background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
}

.stats-icon-pages {
  background: linear-gradient(135deg, #f093fb 0%, #f5576c 100%);
}

.stats-icon-plugins {
  background: linear-gradient(135deg, #4facfe 0%, #00f2fe 100%);
}

.stats-icon-users {
  background: linear-gradient(135deg, #43e97b 0%, #38f9d7 100%);
}

.stats-card-content {
  flex: 1;
  min-width: 0;
}

.stats-card-number {
  font-size: 32px;
  font-weight: 700;
  line-height: 1;
  color: #1d2327;
  margin-bottom: 5px;
}

.stats-card-label {
  font-size: 13px;
  color: #646970;
  font-weight: 500;
  text-transform: uppercase;
  letter-spacing: 0.5px;
  margin-bottom: 8px;
}

.stats-card-link {
  font-size: 13px;
  text-decoration: none;
  color: #2271b1;
  font-weight: 500;
  display: inline-block;
  margin-top: 5px;
}

.stats-card-link:hover {
  color: #135e96;
}

/* Info Grid */
.site-info-grid {
  display: grid;
  grid-template-columns: 1fr 1fr;
  gap: 20px;
  margin-top: 20px;
}

@media (max-width: 1200px) {
  .site-info-grid {
    grid-template-columns: 1fr;
  }
}

.site-info-column {
  display: flex;
  flex-direction: column;
  gap: 20px;
}

/* Postbox Styling */
.postbox {
  border: 1px solid #dcdcde;
  box-shadow: 0 1px 1px rgba(0,0,0,.04);
}

.postbox .postbox-header {
  border-bottom: 1px solid #dcdcde;
}

.postbox .hndle {
  display: flex;
  align-items: center;
  font-size: 14px;
  font-weight: 600;
  padding: 12px 16px;
}

.postbox .inside {
  padding: 16px;
}

/* Form Table Enhancements */
.form-table th {
  width: 180px;
  padding: 12px 0;
  font-weight: 600;
  color: #1d2327;
  font-size: 14px;
  vertical-align: top;
}

.form-table td {
  padding: 12px 0;
  font-size: 14px;
  color: #2c3338;
  word-break: break-word;
}

.form-table tr {
  border-bottom: 1px solid #f0f0f1;
}

.form-table tr:last-child {
  border-bottom: none;
}

.form-table code {
  background: #f0f0f1;
  padding: 3px 8px;
  border-radius: 3px;
  font-size: 13px;
  color: #50575e;
  font-family: Consolas, Monaco, monospace;
}

.site-link {
  text-decoration: none;
  color: #2271b1;
  font-weight: 500;
  display: inline-flex;
  align-items: center;
}

.site-link:hover {
  color: #135e96;
}

/* Visibility Badge */
.visibility-badge {
  display: inline-flex;
  align-items: center;
  gap: 5px;
  padding: 4px 10px;
  border-radius: 3px;
  font-size: 13px;
  font-weight: 500;
}

.visibility-badge .dashicons {
  font-size: 16px;
  width: 16px;
  height: 16px;
}

.visibility-1 {
  background: #d5f2e3;
  color: #00a32a;
}

.visibility-0 {
  background: #f0f0f1;
  color: #646970;
}

.visibility--1,
.visibility--2 {
  background: #ffd4d4;
  color: #d63638;
}

/* Timeline */
.timeline-item {
  display: flex;
  align-items: flex-start;
  gap: 15px;
  padding: 15px 0;
  border-bottom: 1px solid #f0f0f1;
}

.timeline-item:last-child {
  border-bottom: none;
  padding-bottom: 0;
}

.timeline-item:first-child {
  padding-top: 0;
}

.timeline-icon {
  width: 40px;
  height: 40px;
  border-radius: 50%;
  display: flex;
  align-items: center;
  justify-content: center;
  flex-shrink: 0;
}

.timeline-icon .dashicons {
  font-size: 20px;
  width: 20px;
  height: 20px;
  color: #fff;
}

.timeline-icon-created {
  background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
}

.timeline-icon-updated {
  background: linear-gradient(135deg, #f093fb 0%, #f5576c 100%);
}

.timeline-content {
  flex: 1;
  padding-top: 3px;
}

.timeline-label {
  font-size: 13px;
  color: #646970;
  font-weight: 500;
  margin-bottom: 4px;
  text-transform: uppercase;
  letter-spacing: 0.5px;
}

.timeline-date {
  font-size: 14px;
  color: #1d2327;
  font-weight: 600;
}

/* Users List */
.user-count-badge {
  background: #2271b1;
  color: #fff;
  padding: 2px 8px;
  border-radius: 10px;
  font-size: 11px;
  font-weight: 600;
  margin-left: 8px;
}

.users-list {
  padding: 8px 16px;
}

.user-item {
  display: flex;
  align-items: center;
  gap: 12px;
  padding: 12px 0;
  border-bottom: 1px solid #f0f0f1;
}

.user-item:last-child {
  border-bottom: none;
}

.user-avatar {
  flex-shrink: 0;
}

.user-avatar img {
  border-radius: 50%;
  display: block;
}

.user-details {
  flex: 1;
  min-width: 0;
}

.user-name {
  font-size: 14px;
  font-weight: 600;
  margin-bottom: 2px;
}

.user-name a {
  text-decoration: none;
  color: #1d2327;
}

.user-name a:hover {
  color: #2271b1;
}

.user-email {
  font-size: 13px;
  color: #646970;
  overflow: hidden;
  text-overflow: ellipsis;
  white-space: nowrap;
}

.user-email a {
  text-decoration: none;
  color: #646970;
}

.user-email a:hover {
  color: #2271b1;
}

.users-footer {
  padding: 12px 16px;
  background: #f6f7f7;
  border-top: 1px solid #dcdcde;
  text-align: center;
}

.view-all-link {
  text-decoration: none;
  color: #2271b1;
  font-weight: 600;
  font-size: 13px;
  display: inline-flex;
  align-items: center;
  gap: 5px;
}

.view-all-link:hover {
  color: #135e96;
}

.view-all-link .dashicons {
  font-size: 16px;
  width: 16px;
  height: 16px;
}

/* Form Styling */
.form-table input[type="text"],
.form-table input[type="email"],
.form-table textarea,
.form-table select {
  width: 100%;
  max-width: 500px;
}

.form-table textarea {
  resize: vertical;
}

.form-table .description {
  margin-top: 5px;
  margin-bottom: 0;
  font-size: 13px;
  font-style: italic;
}

.form-table fieldset {
  margin: 0;
  padding: 0;
  border: none;
}

.form-table fieldset label {
  display: inline-flex;
  align-items: center;
  gap: 8px;
  font-size: 14px;
  font-weight: 500;
  margin-bottom: 5px;
}

.form-table fieldset input[type="checkbox"] {
  margin: 0;
  width: 18px;
  height: 18px;
}

.form-table fieldset br {
  line-height: 2;
}

/* Save button styling */
.site-actions-bar button[type="submit"] {
  font-weight: 600;
}

/* Responsive Adjustments */
@media (max-width: 782px) {
  .stats-cards-container {
    grid-template-columns: 1fr;
  }
  
  .site-actions-bar {
    flex-direction: column;
    align-items: flex-start !important;
  }
  
  .site-actions-bar > div {
    margin-left: 0 !important;
    width: 100%;
  }
  
  .form-table th,
  .form-table td {
    display: block;
    width: 100%;
    padding: 10px 0;
  }
  
  .form-table th {
    padding-bottom: 5px;
  }
  
  .form-table input[type="text"],
  .form-table input[type="email"],
  .form-table textarea,
  .form-table select {
    max-width: 100%;
  }
}
</style>