<?php if (!defined('ABSPATH')) {
    exit;
} ?>

<div class="wrap">
  <h1><?php esc_html_e('Node Settings', '121-connect'); ?></h1>
  
  <form method="post" action="options.php">
    <?php settings_fields('node_settings_group'); ?>
    
    <div class="notice notice-info">
      <p><?php esc_html_e('Configure your network node settings below. These settings apply to the entire network.', '121-connect'); ?></p>
    </div>
    
    <div class="postbox">
      <div class="postbox-header">
        <p class="hndle" style='padding-left: 15px; font-weight: bold;'><?php esc_html_e('Node Network Configuration', '121-connect'); ?></p>
      </div>
      <div class="inside">
        <table class="form-table" role="presentation">
          <tbody>
            <tr>
              <th scope="row">
                <label for="node_name"><?php esc_html_e('Node Name', '121-connect'); ?></label>
              </th>
              <td>
                <input 
                  name="node_name" 
                  type="text" 
                  id="node_name" 
                  value="<?php echo esc_attr(get_option('node_name', '')); ?>" 
                  class="regular-text" 
                  placeholder="<?php esc_attr_e('Enter node name', '121-connect'); ?>"
                />
                <p class="description">
                  <?php esc_html_e('Enter a descriptive name for this network node. This will be displayed throughout the admin interface.', '121-connect'); ?>
                </p>
              </td>
            </tr>
          </tbody>
        </table>
      </div>
    </div>
    
    <?php submit_button(__('Save Node Settings', '121-connect')); ?>
  </form>
</div>