<?php if (!defined('ABSPATH')) {
    exit;
} ?>

<div class='wrap'>
  <h1><?php esc_html_e('Create New Site', '121-connect'); ?></h1>
  <form method='post'>
    <input type='hidden' name='action' value='create_new_site'>
    <?php wp_nonce_field('create_new_site_action', 'create_new_site_nonce_field'); ?>

    <table class='form-table'>
      <tr>
        <th scope='row'><label for='site_name'><?php esc_html_e('Site Name', '121-connect'); ?></label></th>
        <td><input name='site_name' type='text' id='site_name' value='' class='regular-text' required></td>
      </tr>
      <tr>
        <th scope='row'><label for='domain'><?php esc_html_e('Domain', '121-connect'); ?></label></th>
        <td><input name='domain' type='text' id='domain' value='' class='regular-text' required></td>
      </tr>
      <tr>
        <th scope='row'><label for='admin_email'><?php esc_html_e('Admin Email', '121-connect'); ?></label></th>
        <td><input name='admin_email' type='email' id='admin_email' value='' class='regular-text' required></td>
      </tr>
    </table>

    <?php submit_button(esc_html__('Create Site', '121-connect')); ?>
  </form>
</div>