<?php

namespace _121Digital\Connect\Network\Views\CreateSite;

use _121Digital\Connect\Core\Plugin;
use _121Digital\Connect\Network\Models\NewSiteDTO;
use Exception;

class CreateSite
{
    public function register(): void
    {
        // verify user capabilities
        if (!\_121Digital\Connect\User\UserRoles::isContextAdministrator()) {
            Plugin::die(__('You do not have sufficient permissions to access this page.', '121-connect'));
        }

        $this->render();
    }

    public function render(): void
    {
        try {
            // check if a form was submitted
            if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['create_new_site_nonce_field'])) {
                // verify nonce
                if (!wp_verify_nonce($_POST['create_new_site_nonce_field'], 'create_new_site_action')) {
                    Plugin::die(__('Security check failed. Please try again.', '121-connect'));
                }

                // process form data
                $siteName = sanitize_text_field($_POST['site_name'] ?? '');
                $domain = sanitize_text_field($_POST['domain'] ?? '');
                $adminEmail = sanitize_email($_POST['admin_email'] ?? '');

                // process form data
                $siteName = sanitize_text_field($_POST['site_name'] ?? '');
                $domain = sanitize_text_field($_POST['domain'] ?? '');
                $adminEmail = sanitize_email($_POST['admin_email'] ?? '');

                // basic validation
                if (empty($siteName)) {
                    Plugin::die(__('Site name is required.', '121-connect'));
                }
                if (empty($domain)) {
                    Plugin::die(__('Domain is required.', '121-connect'));
                }
                if (empty($adminEmail)) {
                    Plugin::die(__('Admin email is required.', '121-connect'));
                }

                // create the new site DTO using factory method
                $newSiteDTO = NewSiteDTO::fromArray([
                  'site_name' => $siteName,
                  'domain' => $domain,
                  'admin_email' => $adminEmail
                ]);

                // validate all required fields
                if (!$newSiteDTO->isValid()) {
                    Plugin::die(__('Invalid site data. Please check your input and try again.', '121-connect'));
                }

                // create the site
                try {
                    $siteService = new \_121Digital\Connect\Network\Services\NodeSiteService();
                    $result = $siteService->createSite($newSiteDTO);

                    // show success message
                    wp_redirect(admin_url('admin.php?page=node-admin?site_created=1'));
                } catch (Exception $e) {
                    Plugin::die(__('Error creating site: ', '121-connect') . $e->getMessage());
                }

                // redirect to the overview page
                wp_redirect(admin_url('admin.php?page=node-admin?site_created=1'));
                exit;
            }

            require_once dirname(__FILE__) . '/html/CreateSite.tpl.php';
        } catch (\Exception $e) {
            Plugin::die(__('An error occurred while loading the Create Site page.', '121-connect') . ' ' . $e->getMessage());
        }
    }
}
