<?php

namespace _121Digital\Connect\Network;

use _121Digital\Connect\Network\Views\CreateSite\CreateSite;
use _121Digital\Connect\Network\Views\NodeSettings\NodeSettings;
use _121Digital\Connect\Network\Views\ViewSite\ViewSite;

class NetworkMenu
{
    public function register(): void
    {
        // Correct hook spelling
        add_action('network_admin_menu', [$this, 'removeDefaultCreateSiteSubmenuItem'], 999);
        add_action('network_admin_menu', [$this, 'addCustomCreateSiteSubmenuItem']);
        add_action('network_admin_menu', [$this, 'addNodeSettingsMenuItem']);
        add_action('network_admin_menu', [$this, 'addViewSiteMenuItem']);
    }

    public function removeDefaultCreateSiteSubmenuItem(): void
    {
        // Remove the default WordPress "Add New Site" submenu under Sites
        remove_submenu_page('sites.php', 'site-new.php');
    }

    public function addCustomCreateSiteSubmenuItem(): void
    {
        // Add your custom submenu under the Sites menu in network admin
        $createSiteViewInstance = new CreateSite();
        add_submenu_page(
            'sites.php',                           // Parent menu slug (Sites menu)
            __('Create New Site', '121-connect'), // Page title
            __('Create New Site', '121-connect'), // Menu title
            'manage_network',                      // Capability
            'custom-create-site',                  // Unique slug (do not use site-new.php)
            [$createSiteViewInstance, 'register'] // Callback to render page
        );
    }

    public function addNodeSettingsMenuItem(): void
    {
        $nodeSettingsViewInstance = new NodeSettings();
        add_menu_page(
            __('Node Settings', '121-connect'),   // Page title
            __('Node Settings', '121-connect'),   // Menu title
            'manage_network',                      // Capability
            'node-settings',                       // Unique slug
            [$nodeSettingsViewInstance, 'register'] // Callback to render page
        );
    }

    public function addViewSiteMenuItem(): void
    {
        $viewSiteInstance = new ViewSite();
        add_submenu_page(
            null,                           // Parent menu slug (Sites menu)
            __('View Site', '121-connect'),       // Page title
            __('View Site', '121-connect'),       // Menu title
            'manage_network',                      // Capability
            'custom-view-site',                    // Unique slug
            [$viewSiteInstance, 'register']       // Callback to render page
        );
    }
}
