<?php

/**
 * Legacy Function Wrappers
 *
 * @package _121Digital\Connect
 */

use _121Digital\Connect\Core\Plugin;

/**
 * Backward compatibility functions for procedural code
 * These functions wrap the new OOP implementation
 */

// Make functions available in global namespace
if (!function_exists('sc_matomo_has_tracking_code')) {
    /**
     * Check if a Matomo tracking code has been set
     *
     * @return bool
     */
    function sc_matomo_has_tracking_code(): bool
    {
        $plugin = Plugin::getInstance();
        $matomo = $plugin->getComponent('matomo');
        return $matomo ? $matomo->hasTrackingCode() : false;
    }
}

if (!function_exists('sc_matomo_set_tracking_code')) {
    /**
     * Save or update the Matomo tracking code
     *
     * @param string $trackingCode
     * @return void
     */
    function sc_matomo_set_tracking_code(string $trackingCode): void
    {
        $plugin = Plugin::getInstance();
        $matomo = $plugin->getComponent('matomo');
        if ($matomo) {
            $matomo->setTrackingCode($trackingCode);
        }
    }
}

if (!function_exists('sc_matomo_get_tracking_code')) {
    /**
     * Retrieve the Matomo tracking code
     *
     * @return string
     */
    function sc_matomo_get_tracking_code(): string
    {
        $plugin = Plugin::getInstance();
        $matomo = $plugin->getComponent('matomo');
        return $matomo ? $matomo->getTrackingCode() : '';
    }
}

if (!function_exists('sc_matomo_can_render_tracking_code')) {
    /**
     * Validate if tracking code can be safely rendered
     *
     * @return bool
     */
    function sc_matomo_can_render_tracking_code(): bool
    {
        $plugin = Plugin::getInstance();
        $matomo = $plugin->getComponent('matomo');
        return $matomo ? $matomo->canRenderTrackingCode() : false;
    }
}

if (!function_exists('sc_matomo_tracking_code_empty')) {
    /**
     * Check if tracking code is empty
     *
     * @return bool
     */
    function sc_matomo_tracking_code_empty(): bool
    {
        $plugin = Plugin::getInstance();
        $matomo = $plugin->getComponent('matomo');
        return $matomo ? $matomo->trackingCodeEmpty() : true;
    }
}

if (!function_exists('sc_render_matomo_tracking_code')) {
    /**
     * Render the Matomo tracking code
     *
     * @return void
     */
    function sc_render_matomo_tracking_code(): void
    {
        $plugin = Plugin::getInstance();
        $matomo = $plugin->getComponent('matomo');
        if ($matomo) {
            $matomo->renderTrackingCode();
        }
    }
}
