/**
 * Split items into rows based on items per row
 * @param {Array} items - Items to split
 * @param {number} itemsPerRow - Number of items per row
 * @returns {Array} - Array of rows
 */
const splitItemsIntoRows = (items, itemsPerRow = 3) => {
  const rows = []
  for (let i = 0; i < items.length; i += itemsPerRow) {
    rows.push(items.slice(i, i + itemsPerRow))
  }
  return rows
}

export default splitItemsIntoRows


