import { useState } from 'react'
import { apiCall } from './apiHelper'

/**
 * Reset user settings
 * Endpoint: resetUserSettings
 */
const resetUserSettings = () => {
  const [loading, setLoading] = useState(false)
  const [data, setData] = useState(null)
  const [error, setError] = useState(null)

  const reset = async () => {
    try {
      setLoading(true)
      setError(null)
      const result = await apiCall('resetUserSettings', 'POST')
      setData(result)
      setLoading(false)
    } catch (err) {
      setError(err.message)
      setLoading(false)
    }
  }

  return { loading, data, error, reset }
}

export default resetUserSettings
