import { useState, useEffect } from 'react'
import { apiCall } from './apiHelper'

const installFreeTemplateKit = ({ templateKitId }) => {
  const [loading, setLoading] = useState(true)
  const [data, setData] = useState(null)
  const [error, setError] = useState(null)

  useEffect(() => {
    if (!templateKitId) {
      setLoading(false)
      return
    }

    const install = async () => {
      try {
        setLoading(true)
        setError(null)
        const result = await apiCall('installFreeTemplateKit', 'POST', { templateKitId })
        setData(result)
        setLoading(false)
      } catch (err) {
        setError(err.message)
        setLoading(false)
      }
    }

    install()
  }, [templateKitId])

  return { loading, data, error }
}

export default installFreeTemplateKit


