import { useState, useEffect } from 'react'
import { apiCall } from './apiHelper'

const importPhoto = ({ photoId }) => {
  const [loading, setLoading] = useState(true)
  const [data, setData] = useState(null)
  const [error, setError] = useState(null)

  useEffect(() => {
    if (!photoId) {
      setLoading(false)
      return
    }

    const importImg = async () => {
      try {
        setLoading(true)
        setError(null)
        const result = await apiCall('importPhoto', 'POST', { photoId })
        setData(result)
        setLoading(false)
      } catch (err) {
        setError(err.message)
        setLoading(false)
      }
    }

    importImg()
  }, [photoId])

  return { loading, data, error }
}

export default importPhoto


