import { useState, useEffect } from 'react'
import { apiCall } from './apiHelper'

const importElementorTemplateImage = ({ id, url, templateKitName }) => {
  const [loading, setLoading] = useState(true)
  const [data, setData] = useState(null)
  const [error, setError] = useState(null)

  useEffect(() => {
    if (!id || !url) {
      console.warn('Missing image id or url:', { id, url })
      setLoading(false)
      return
    }

    const importImage = async () => {
      try {
        setLoading(true)
        setError(null)
        console.log('Importing image:', { id, url, templateKitName })
        const result = await apiCall('importElementorTemplateImage', 'POST', { id, url, templateKitName })
        console.log('Image import result:', result)
        setData(result)
        setLoading(false)
      } catch (err) {
        console.error('Image import API error:', err)
        setError(err.message)
        setLoading(false)
      }
    }

    importImage()
  }, [id, url, templateKitName])

  return { loading, data, error }
}

export default importElementorTemplateImage


