import { useState, useEffect } from 'react'
import { apiCall } from './apiHelper'

const getSingleTemplateImportData = ({ templateKitId, templateId }) => {
  const [loading, setLoading] = useState(true)
  const [data, setData] = useState(null)
  const [error, setError] = useState(null)

  useEffect(() => {
    if (!templateKitId || templateId === null || templateId === undefined) {
      setLoading(false)
      return
    }

    const fetch = async () => {
      try {
        setLoading(true)
        setError(null)
        console.log('Fetching template data:', { templateKitId, templateId })
        const result = await apiCall('getSingleTemplateImportData', 'POST', { templateKitId, templateId })
        console.log('Template data fetched:', result)
        setData(result)
        setLoading(false)
      } catch (err) {
        console.error('Fetch template data error:', err)
        setError(err.message)
        setLoading(false)
      }
    }

    fetch()
  }, [templateKitId, templateId])

  return { loading, data, error }
}

export default getSingleTemplateImportData


