import { useState, useEffect } from 'react'
import { apiCall } from './apiHelper'

const getElementorGlobalStyleTemplates = () => {
  const [loading, setLoading] = useState(true)
  const [data, setData] = useState(null)
  const [error, setError] = useState(null)

  useEffect(() => {
    const fetch = async () => {
      try {
        setLoading(true)
        setError(null)
        const result = await apiCall('getElementorGlobalStyleTemplates', 'POST')
        setData(result)
        setLoading(false)
      } catch (err) {
        setError(err.message)
        setLoading(false)
      }
    }

    fetch()
  }, [])

  return { loading, data, error }
}

export default getElementorGlobalStyleTemplates


