import { useState, useEffect } from 'react'
import { apiCall } from './apiHelper'

const fetchIndividualTemplates = ({ templateKitId, templateId, refresh }) => {
  const [loading, setLoading] = useState(true)
  const [data, setData] = useState(null)
  const [error, setError] = useState(null)

  useEffect(() => {
    const fetch = async () => {
      try {
        setLoading(true)
        setError(null)
        // The PHP backend expects 'id' not 'templateKitId'
        const result = await apiCall('fetchIndividualTemplates', 'POST', { 
          id: templateKitId,
          templateId 
        })
        setData(result)
        setLoading(false)
      } catch (err) {
        setError(err.message)
        setLoading(false)
      }
    }

    fetch()
  }, [templateKitId, templateId, refresh])

  return { loading, data, error }
}

export default fetchIndividualTemplates

