(function() {
  "use strict";
  (function() {
    if (typeof jQuery === "undefined") {
      return;
    }
    jQuery(function($) {
      function openEnvatoModal(event) {
        let insertPosition = 0;
        if (elementorCommon) {
          const $parent = $(event.target).parents(".elementor-section-wrap");
          if ($parent.length > 0) {
            insertPosition = $(this).parents(".elementor-add-section").index();
          } else {
            insertPosition = -1;
          }
        }
        if (insertPosition >= 0) {
          $(event.target).parents(".elementor-add-section-inline").remove();
        }
        let modalHolder = document.getElementById("envato-elements-magic-button-holder");
        if (!modalHolder) {
          modalHolder = document.createElement("div");
          modalHolder.id = "envato-elements-magic-button-holder";
          document.body.appendChild(modalHolder);
        }
        const magicButtonConfig = {
          mode: "elementorMagicButton",
          closeCallback: function() {
            window.envatoElements.closeMagicButton(modalHolder);
          },
          insertCallback: function(templateData) {
            console.log("insertCallback received:", templateData);
            if (typeof elementor === "undefined") {
              console.error("Elementor is not available");
              return;
            }
            if (templateData.imported_template_id) {
              console.log("Inserting template ID:", templateData.imported_template_id);
              if (typeof $e !== "undefined" && elementor.templates) {
                elementor.templates.requestTemplateContent(
                  "local",
                  templateData.imported_template_id,
                  {
                    data: {
                      edit_mode: "builder",
                      display: true,
                      with_page_settings: false
                    },
                    success: function(data) {
                      console.log("Template content received:", data);
                      if (data && data.content && Array.isArray(data.content)) {
                        const historyId = $e.internal("document/history/start-log", {
                          type: "add",
                          title: "Add Envato Elements Template"
                        });
                        for (let i = 0; i < data.content.length; i++) {
                          $e.run("document/elements/create", {
                            container: elementor.getPreviewContainer(),
                            model: data.content[i],
                            options: insertPosition >= 0 ? { at: insertPosition++ } : {}
                          });
                        }
                        $e.internal("document/history/end-log", { id: historyId });
                      }
                      window.envatoElements.closeMagicButton(modalHolder);
                    },
                    error: function(err) {
                      console.error("Failed to get template content:", err);
                      alert("Failed to insert template. Please try again.");
                    }
                  }
                );
              } else if (elementor.templates) {
                elementor.templates.importTemplate({
                  template_id: templateData.imported_template_id
                });
                window.envatoElements.closeMagicButton(modalHolder);
              }
              return;
            }
            if (!templateData.content || !Array.isArray(templateData.content)) {
              console.error("No content to insert", templateData);
              return;
            }
            if (typeof $e !== "undefined") {
              const historyId = $e.internal("document/history/start-log", {
                type: "add",
                title: "Add Envato Elements Content"
              });
              for (let i = 0; i < templateData.content.length; i++) {
                $e.run("document/elements/create", {
                  container: elementor.getPreviewContainer(),
                  model: templateData.content[i],
                  options: insertPosition >= 0 ? { at: insertPosition++ } : {}
                });
              }
              $e.internal("document/history/end-log", { id: historyId });
            } else {
              const model = new Backbone.Model({
                getTitle: () => "Envato Elements Template"
              });
              elementor.channels.data.trigger("template:before:insert", model);
              for (let i = 0; i < templateData.content.length; i++) {
                elementor.getPreviewView().addChildElement(
                  templateData.content[i],
                  insertPosition >= 0 ? { at: insertPosition++ } : null
                );
              }
              elementor.channels.data.trigger("template:after:insert", {});
            }
            window.envatoElements.closeMagicButton(modalHolder);
          }
        };
        window.envatoElements.initMagicButton(modalHolder, magicButtonConfig);
      }
      const addSectionTemplate = $("#tmpl-elementor-add-section");
      if (addSectionTemplate.length > 0) {
        let templateContent = addSectionTemplate.text();
        templateContent = templateContent.replace(
          '<div class="elementor-add-section-drag-title',
          '<div class="elementor-add-section-area-button elementor-add-envato-button" title="Envato Elements"> <i class="dashicons dashicons-download"></i> </div><div class="elementor-add-section-drag-title'
        );
        addSectionTemplate.text(templateContent);
        elementor.on("preview:loaded", function() {
          $(elementor.$previewContents[0].body).on("click", ".elementor-add-envato-button", openEnvatoModal);
        });
      }
    });
  })();
})();
//# sourceMappingURL=elementor_modal.js.map
