<?php

namespace _121Digital\Connect\Core;

class Environment
{
    public static function isProduction(): bool
    {
        return defined('WP_ENV') && WP_ENV === 'production';
    }

    public static function isPreview(): bool
    {
        return defined('WP_ENV') && WP_ENV === 'staging';
    }

    public static function isDevelopment(): bool
    {
        return !self::isProduction() && !self::isPreview();
    }

    public static function isEcommerceActive(): bool
    {
        return class_exists('WooCommerce');
    }

    public static function isGoogleSiteKitActive(): bool
    {
        return class_exists('\Google\Site_Kit\Plugin');
    }

    public static function isElementorActive(): bool
    {
        return class_exists('\Elementor\Plugin');
    }

    public static function isDefaultTheme(): bool
    {
        $theme = wp_get_theme();
        return $theme->get('Name') === 'Hello Builder';
    }

    public static function isMultisiteNode(): bool
    {
        return is_multisite();
    }

    public static function isWordpressPendingUpdate(): bool
    {
        $core_updates = get_site_transient('update_core');
        if (isset($core_updates->updates) && is_array($core_updates->updates)) {
            foreach ($core_updates->updates as $update) {
                if (version_compare(get_bloginfo('version'), $update->current, '<')) {
                    return true;
                }
            }
        }
        return false;
    }

    public static function isPluginPendingUpdate(string $plugin_slug): bool
    {
        $plugin_updates = get_site_transient('update_plugins');
        if (isset($plugin_updates->response[$plugin_slug])) {
            return true;
        }
        return false;
    }
}
