<?php

/**
 * Plugin Update Command
 *
 * @package _121Digital\Connect
 */

namespace _121Digital\Connect\Commands\Plugin;

use _121Digital\Connect\Commands\CommandBase;

/**
 * Handles the execution of a plugin update check using the
 * Plugin Update Checker (PUC) library.
 */
class Update extends CommandBase
{
    /**
     * Executes the plugin update process.
     *
     * @return array Associative array with success status, message, and data.
     */
    public function execute(): array
    {
        try {
            global $_SC_plugin_update_checker;

            if (!isset($_SC_plugin_update_checker)) {
                throw new \Exception('Could not init 121Connect plugin update service.');
            }

            $pluginUpdateChecker = $_SC_plugin_update_checker;
            $pluginUpdateChecker->checkForUpdates();

            return $this->success('The plugin update check has been completed.');
        } catch (\Exception $e) {
            return $this->error('The plugin could not be updated: ' . $e->getMessage());
        }
    }
}
