<?php

/**
 * Matomo Set Tracking Code Command
 *
 * @package _121Digital\Connect
 */

namespace _121Digital\Connect\Commands\Matomo;

use _121Digital\Connect\Commands\CommandBase;

/**
 * Command to set Matomo tracking code.
 */
class SetTrackingCode extends CommandBase
{
    /**
     * Execute the command to set the tracking code.
     *
     * @return array An associative array with the result of the command execution.
     */
    public function execute(): array
    {
        try {
            if (!function_exists('sc_matomo_set_tracking_code')) {
                throw new \Exception('Matomo tracking functions not available.');
            }

            $trackingCode = $this->getArg('tracking_code');

            if (empty($trackingCode)) {
                throw new \Exception('The tracking code is required.');
            }

            sc_matomo_set_tracking_code($trackingCode);

            return $this->success('The tracking code has been updated.');
        } catch (\Exception $e) {
            return $this->error('The plugin could not set the tracking code: ' . $e->getMessage());
        }
    }
}
