<?php

/**
 * Get Favicon Command
 *
 * @package _121Digital\Connect
 */

namespace _121Digital\Connect\Commands\Favicon;

use _121Digital\Connect\Commands\CommandBase;

/**
 * Command to get the site's favicon URL.
 */
class Get extends CommandBase
{
    /**
     * Retrieve the favicon URL for the site.
     *
     * @return string The URL of the favicon image.
     */
    private function getFaviconUrl(): string
    {
        return get_site_icon_url() ?: '';
    }

    /**
     * Execute the command to get the favicon.
     *
     * @return array An associative array of site metadata.
     */
    public function execute(): array
    {
        $faviconUrl = $this->getFaviconUrl();

        return $this->success('The command has executed.', ['favicon_url' => $faviconUrl]);
    }
}
