<?php

namespace _121Digital\Connect\Authentication;

use _121Digital\Connect\Authentication\Styles\AuthStyles;
use _121Digital\Connect\Core\Plugin;

class Login
{
    public static function isContextAuth(): bool
    {
        if (defined('WP_LOGIN_URL') || in_array($GLOBALS['pagenow'], ['wp-login.php', 'wp-register.php'], true)) {
            return true;
        } else {
            return false;
        }
    }

    public function register(): void
    {
        if (!self::isContextAuth()) {
            return;
        }

        // init the auth styls module...
        $authStyles = new AuthStyles();
        $authStyles->register();

        // customise the login logo...
        add_action('login_enqueue_scripts', [$this, 'hideDefaultLoginLogo'], 20);
        add_action('login_message', [$this, 'renderCustomLoginLogo'], 5);
    }

    public function hideDefaultLoginLogo(): void
    {
        if (!self::isContextAuth()) {
            return;
        }

        $pluginUrl = Plugin::getInstance()->getConfig('plugin_url');
        $logoUrl = $pluginUrl . 'static/brand_icon.png';

        echo "<style type='text/css'>
        .login h1 a {
          background-image: url('{$logoUrl}') !important;
          width: 100%;
          background-size: contain;
          background-repeat: no-repeat;
          padding-bottom: 30px;
        }</style>";
    }

    public function renderCustomLoginLogo(): void
    {
        if (!self::isContextAuth()) {
            return;
        }

        $pluginUrl = Plugin::getInstance()->getConfig('plugin_url');
        $logoUrl = $pluginUrl . 'static/reg121_brand.svg';

        echo '<div style="text-align:center;margin-bottom:20px;"><img src="' . esc_url($logoUrl) . '" alt="Login Image" style="max-width:200px;height:auto;"></div>';
    }
}
