<?php

namespace _121Digital\Connect\Admin;

class Users
{
    public function register(): void
    {
        add_action('admin_menu', [$this, 'maybeHideAdminUsers'], 999);
    }

    private function hideAdminUsersView(): void
    {
        // Remove the Users menu item
        remove_menu_page('users.php');

        // Block direct access to users.php
        global $pagenow;
        if ($pagenow === 'users.php' || $pagenow === 'user-new.php' || $pagenow === 'profile.php') {
            wp_redirect(admin_url());
            exit;
        }
    }

    public function maybeHideAdminUsers(): void
    {
        if (current_user_can('manage_options')) {
            return; // Only proceed for non-admin users
        } else {
            // hide the users view.
            $this->hideAdminUsersView();
        }
    }
}
