<?php

namespace _121Digital\Connect\Admin\Settings;

use _121Digital\Connect\User\UserRoles;

class Settings
{
    public function register(): void
    {
        add_action('admin_init', [$this, 'removePermalinksSubmenueItem']);
        add_action('admin_init', [$this, 'removePermalinksPageAccess']);
        add_action('admin_init', [$this, 'removeDiscussionSubmenueItem']);
        add_action('admin_init', [$this, 'removeDiscussionPageAccess']);
        add_action('admin_init', [$this, 'removeReadingSubmenueItem']);
        add_action('admin_init', [$this, 'removeReadingPageAccess']);
        add_action('admin_init', [$this, 'removeWritingSubmenueItem']);
        add_action('admin_init', [$this, 'removeWritingPageAccess']);
        add_action('admin_init', [$this, 'removePrivacySubmenueItem']);
        add_action('admin_init', [$this, 'removePrivacyPageAccess']);

        add_action('admin_init', [$this, 'renameGeneralSettingsItem']);
    }

    public function renameGeneralSettingsItem(): void
    {
        // only rename the general settings menu for users with the REG121_User role
        if (!UserRoles::isContextUser()) {
            return;
        }

        global $menu;
        foreach ($menu as $index => $item) {
            if ($item[2] === 'options-general.php') {
                $menu[$index][0] = 'Site Settings';
                break;
            }
        }

        // also rename the 2nd level General Settings submenu item
        global $submenu;
        if (isset($submenu['options-general.php'])) {
            foreach ($submenu['options-general.php'] as $index => $item) {
                if ($item[2] === 'options-general.php') {
                    $submenu['options-general.php'][$index][0] = 'General Site Settings';
                    break;
                }
            }
        }

        // also rename 2nd level media settings submenu item
        if (isset($submenu['options-general.php'])) {
            foreach ($submenu['options-general.php'] as $index => $item) {
                if ($item[2] === 'options-media.php') {
                    $submenu['options-general.php'][$index][0] = 'Media Settings';
                    break;
                }
            }
        }
    }

    public function removePermalinksSubmenueItem(): void
    {
        // only remove the permalinks submenu for users with the REG121_User role
        if (!UserRoles::isContextUser()) {
            return;
        }

        global $submenu;
        if (isset($submenu['options-general.php'])) {
            foreach ($submenu['options-general.php'] as $index => $item) {
                if ($item[2] === 'options-permalink.php') {
                    unset($submenu['options-general.php'][$index]);
                }
            }
        }
    }

    public function removePermalinksPageAccess()
    {
        // only block access to the permalinks page for users with the REG121_User role
        if (!UserRoles::isContextUser()) {
            return;
        }

        global $pagenow;
        if ($pagenow === 'options-permalink.php') {
            wp_redirect(admin_url());
            exit;
        }
    }

    public function removeDiscussionSubmenueItem(): void
    {
        // only remove the discussion submenu for users with the REG121_User role
        if (!UserRoles::isContextUser()) {
            return;
        }

        global $submenu;
        if (isset($submenu['options-general.php'])) {
            foreach ($submenu['options-general.php'] as $index => $item) {
                if ($item[2] === 'options-discussion.php') {
                    unset($submenu['options-general.php'][$index]);
                }
            }
        }
    }

    public function removeDiscussionPageAccess()
    {
        // only block access to the discussion page for users with the REG121_User role
        if (!UserRoles::isContextUser()) {
            return;
        }

        global $pagenow;
        if ($pagenow === 'options-discussion.php') {
            wp_redirect(admin_url());
            exit;
        }
    }

    public function removeReadingSubmenueItem(): void
    {
        // only remove the reading submenu for users with the REG121_User role
        if (!UserRoles::isContextUser()) {
            return;
        }

        global $submenu;
        if (isset($submenu['options-general.php'])) {
            foreach ($submenu['options-general.php'] as $index => $item) {
                if ($item[2] === 'options-reading.php') {
                    unset($submenu['options-general.php'][$index]);
                }
            }
        }
    }

    public function removeReadingPageAccess()
    {
        // only block access to the reading page for users with the REG121_User role
        if (!UserRoles::isContextUser()) {
            return;
        }

        global $pagenow;
        if ($pagenow === 'options-reading.php') {
            wp_redirect(admin_url());
            exit;
        }
    }

    public function removeWritingSubmenueItem(): void
    {
        // only remove the writing submenu for users with the REG121_User role
        if (!UserRoles::isContextUser()) {
            return;
        }

        global $submenu;
        if (isset($submenu['options-general.php'])) {
            foreach ($submenu['options-general.php'] as $index => $item) {
                if ($item[2] === 'options-writing.php') {
                    unset($submenu['options-general.php'][$index]);
                }
            }
        }
    }

    public function removeWritingPageAccess()
    {
        // only block access to the writing page for users with the REG121_User role
        if (!UserRoles::isContextUser()) {
            return;
        }

        global $pagenow;
        if ($pagenow === 'options-writing.php') {
            wp_redirect(admin_url());
            exit;
        }
    }

    public function removePrivacySubmenueItem(): void
    {
        // only remove the privacy submenu for users with the REG121_User role
        if (!UserRoles::isContextUser()) {
            return;
        }

        global $submenu;
        if (isset($submenu['options-general.php'])) {
            foreach ($submenu['options-general.php'] as $index => $item) {
                if ($item[2] === 'options-privacy.php') {
                    unset($submenu['options-general.php'][$index]);
                }
            }
        }
    }

    public function removePrivacyPageAccess()
    {
        // only block access to the privacy page for users with the REG121_User role
        if (!UserRoles::isContextUser()) {
            return;
        }

        global $pagenow;
        if ($pagenow === 'options-privacy.php') {
            wp_redirect(admin_url());
            exit;
        }
    }
}
