<?php

/**
 * Admin Profile
 *
 * @package _121Digital\Connect
 */

namespace _121Digital\Connect\Admin\Profile;

use _121Digital\Connect\Core\Environment;

/**
 * Profile Class
 *
 * Handles admin profile customization
 */
class Profile
{
    /**
     * Register profile hooks
     *
     * @return void
     */
    public function register(): void
    {
        // do not execute module in the context of user profile editing in network admin
        if (Environment::isMultisiteNode() && is_network_admin()) {
            return;
        }

        add_action('admin_head-user-edit.php', [$this, 'renameProfilePageTitle']);
        add_action('admin_head-user-edit.php', [$this, 'removeAdminColorSchemePicker']);
        add_action('admin_head', function () {
            echo '<style>.user-admin-color-wrap { display:none !important; }</style>';
            echo '<style>#color-picker, .color-option { display:none !important; }</style>';
        });

        $this->renameProfilePageTitle();
        $this->renameProfileAdminMenu();

        $this->removeProfilePersonalOptions();
        $this->removeProfileContactInfo();
        $this->removeAboutYourself();
        $this->profileRemoveNameSettings();
        $this->removeElementorAISettings();
    }

    public function renameProfileAdminMenu(): void
    {
        add_action('admin_menu', function () {
            global $menu;
            foreach ($menu as $key => $menu_item) {
                if ($menu_item[2] === 'profile.php') {
                    $menu[$key][0] = 'Account Settings';
                    break;
                }
            }
        });
    }

    public function renameProfilePageTitle(): void
    {
        add_filter('gettext', function ($translated_text, $text, $domain) {
            global $pagenow;
            if ($pagenow === 'profile.php' && $text === 'Profile') {
                return 'Website Account Settings'; // Change as needed
            }
            return $translated_text;
        }, 10, 3);
    }

    public function removeProfilePersonalOptions(): void
    {
        add_action('admin_head', function () {
            ob_start(function ($subject) {
                $subject = preg_replace('#<h2>Personal Options</h2>.+?<h2>#s', '<h2>', $subject);
                return $subject;
            });
        });
        add_action('admin_footer', function () {
            ob_end_flush();
        });
    }

    public function removeProfileContactInfo(): void
    {
        add_action('admin_head', function () {
            ob_start(function ($subject) {
                $subject = preg_replace('#<h2>Contact Info</h2>.+?<h2>#s', '<h2>', $subject);
                return $subject;
            });
        });
        add_action('admin_footer', function () {
            ob_end_flush();
        });
    }

    public function removeAboutYourself(): void
    {
        add_action('admin_head', function () {
            ob_start(function ($subject) {
                $subject = preg_replace('#<h2>About Yourself</h2>.+?<h2>#s', '<h2>', $subject);
                return $subject;
            });
        });
        add_action('admin_footer', function () {
            ob_end_flush();
        });
    }

    public function profileRemoveNameSettings(): void
    {
        add_action('admin_head', function () {
            ob_start(function ($subject) {
                $subject = preg_replace('#<h2>Name</h2>.+?<h2>#s', '<h2>', $subject);
                return $subject;
            });
        });
        add_action('admin_footer', function () {
            ob_end_flush();
        });
    }

    public function removeElementorAISettings(): void
    {
        add_action('admin_head', function () {
            ob_start(function ($subject) {
                $subject = preg_replace('#<h2>Elementor - AI</h2>.+?<h2>#s', '<h2>', $subject);
                return $subject;
            });
        });
        add_action('admin_footer', function () {
            ob_end_flush();
        });
    }

    /**
     * Remove admin color scheme picker
     *
     * @return void
     */
    public function removeAdminColorSchemePicker(): void
    {
        add_action('admin_head', function () {
            echo '<style>#color-picker, .color-option { display:none !important; }</style>';
        });
        remove_action('admin_color_scheme_picker', 'admin_color_scheme_picker');
    }
}
