<?php

namespace _121Digital\Connect\Admin\Posts;

class Post
{
    public function register(): void
    {
        add_action('admin_init', [$this, 'removeEditWithElementorButton'], 999);
    }

    public function removeEditWithElementorButton(): void
    {
        if (!\_121Digital\Connect\Core\Environment::isElementorActive()) {
            return;
        }

        // Run only on the post editor screen
        add_action('admin_head', function () {
            $screen = get_current_screen();
            if ($screen && $screen->base === 'post') {
                echo '<style>
                    #elementor-switch-mode { display: none !important; }
                </style>';
            }
        });

        // Prevent Elementor editor access globally for these users
        add_filter('elementor/utils/is_editable', '__return_false');
    }
}
