jQuery(document).ready(function($){
    // Select the Add New Page button
    var $addPageBtn = $('.page-title-action');

    // Change label (optional)
    $addPageBtn.text('Create Page');

    // Change the action (optional)
    $addPageBtn.attr('href', 'https://your-custom-url.com');

    // Or add a custom JS handler:
    $addPageBtn.on('click', function(e){

        // Prevent default action from navigating to the wp new page
        e.preventDefault();

        const bodyContent = `
          <form id="create-page-form" method='post'>
            <input type="hidden" name="action" value="create_custom_page" />

            <div class="form-field">
              <label for="page-title">Page Title</label>
              <input type="text" id="page-title" name="page-title" class="regular-text" required />
            </div>
            <br />
            <div class="form-field">
              <label for="template-type">Page Template Type</label> <br />
              <select id="template-type" name="template-type" class="regular-text">
                <option value="full-width">Full Width Canvas (Default)</option>
                <option value="boxed">Boxed Canvas</option>
              </select>
            </div>
          </form>

          <br />
        `;

        // Your custom logic here
        FluentUIModal.show({
          title: "Create Page",
          body: bodyContent,
          footer: `
            <button class="button-primary" id="create-page-submit">Create Page</button>
            <button class="button" onclick="FluentUIModal.hide()">Cancel</button>
          `
        });

        // Attach event listener after modal is rendered
        setTimeout(function() {
          const submitBtn = document.getElementById('create-page-submit');
          if (submitBtn) {
            submitBtn.addEventListener('click', function() {
              // Access form data after modal is rendered
              const form = document.getElementById('create-page-form');
              if (form) {
                // Ensure nonce and action fields are present
                if (typeof createPageForm !== 'undefined' && createPageForm.nonce) {
                  let nonceInput = form.querySelector('input[name="_wpnonce"]');
                  if (!nonceInput) {
                    nonceInput = document.createElement('input');
                    nonceInput.type = 'hidden';
                    nonceInput.name = '_wpnonce';
                    form.appendChild(nonceInput);
                  }
                  nonceInput.value = createPageForm.nonce;
                }

                // Add action and post_type hidden fields expected by server
                let actionInput = form.querySelector('input[name="action"]');
                if (!actionInput) {
                  actionInput = document.createElement('input');
                  actionInput.type = 'hidden';
                  actionInput.name = 'action';
                  form.appendChild(actionInput);
                }
                actionInput.value = 'create_custom_page';

                let postTypeInput = form.querySelector('input[name="post_type"]');
                if (!postTypeInput) {
                  postTypeInput = document.createElement('input');
                  postTypeInput.type = 'hidden';
                  postTypeInput.name = 'post_type';
                  form.appendChild(postTypeInput);
                }
                postTypeInput.value = 'page';

                form.submit();
                FluentUIModal.hide();
              }
            });
          }
        }, 100);
        // Optionally, redirect or open a modal, etc.
    });
});