<?php

namespace _121Digital\Connect\Admin\Pages;

use _121Digital\Connect\Core\Environment;

class Page
{
    public function register(): void
    {
        add_action('admin_head', [$this, 'renamePageTitle']);
        add_action('admin_head', [$this, 'removePageContentEditor']);
        add_action('admin_init', [$this, 'maybeRedirectToPages']);
        add_action('admin_head', [$this, 'removePageElementorContentEditor']);
        add_action('admin_head', [$this, 'removeAddPageButton']);
        add_action('edit_form_after_title', [$this, 'addBackButton']);

        add_action('edit_form_after_title', [$this, 'addCustomEditWithElementorButton']);
    }

    private static function isContextPageEdit(): bool
    {
        // Check if we are in admin area
        if (!is_admin()) {
            return false;
        }

        $screen = get_current_screen();
        return $screen && $screen->base === 'post' && $screen->post_type === 'page';
    }

    public function removePageContentEditor(): void
    {
        remove_post_type_support('page', 'editor');
    }

    // Updated: maybeRedirectToPages will redirect if edit_settings GET param is not present
    public function maybeRedirectToPages(): void
    {
        // Only do this on post.php in admin
        if (
            is_admin() &&
            isset($_GET['action']) && $_GET['action'] === 'edit' &&
            isset($_GET['post']) &&
            !isset($_GET['edit_settings'])
        ) {
            // Get the post type to ensure we only redirect pages, not other post types
            $post_id = isset($_GET['post']) ? intval($_GET['post']) : 0;
            $post_type = get_post_type($post_id);

            // Only redirect if this is actually a page and not
            // for example, a blog post...
            if ($post_type === 'page') {
                wp_redirect(admin_url('edit.php?post_type=page'));
                exit;
            }
        }
    }

    public function renamePageTitle(): void
    {
        if (self::isContextPageEdit()) {
            global $title;
            $pageTitle = get_the_title();
            $title = $pageTitle . ' - Page Settings';
        }
    }

    public function removeAddPageButton(): void
    {
        if (self::isContextPageEdit()) {
            echo '<style>
                .page-title-action { display: none !important; }
            </style>';
        }
    }

    public function addBackButton(): void
    {
        if (self::isContextPageEdit()) {
            echo "<a class='button button-grey' href='" . esc_url(admin_url('edit.php?post_type=page')) . "' style='margin-right: 8px;'>Back to Pages</a>";
        }
    }

    public function removePageElementorContentEditor(): void
    {
        if (self::isContextPageEdit()) {
            echo '<style>#elementor-switch-mode {display: none !important;}</style>';
            echo '<style>#elementor-editor {display: none !important;}</style>';
        }
    }

    public function addCustomEditWithElementorButton(): void
    {
        if (self::isContextPageEdit() && Environment::isElementorActive()) {
            echo "<a class='button button-primary' href='" . esc_url(admin_url('post.php?post=' . get_the_ID() . '&action=elementor')) . "' style='margin-left: 8px;'>Edit Page Content</a>";
        }
    }
}
