<?php

namespace _121Digital\Connect\Admin;

class AdminUpdates
{
    public function register(): void
    {
        add_action('admin_menu', [$this, 'maybeHideAdminUpdates'], 999);
    }

    private function hideAdminUpdatesView(): void
    {
        // Remove the Dashboard → Updates menu item
        remove_submenu_page('index.php', 'update-core.php');

        // Block direct access to update-core.php
        global $pagenow;
        if ($pagenow === 'update-core.php') {
            wp_redirect(admin_url());
            exit;
        }
    }

    private function hideAdminUpdateNotices(): void
    {
        // Suppress update notifications
        add_filter('pre_site_transient_update_core', '__return_null');
        add_filter('pre_site_transient_update_plugins', '__return_null');
        add_filter('pre_site_transient_update_themes', '__return_null');
    }

    public function maybeHideAdminUpdates(): void
    {
        if (current_user_can('manage_options')) {
            return; // Only proceed for non-admin users
        } else {
            // hide the updates view.
            $this->hideAdminUpdatesView();
            $this->hideAdminUpdateNotices();
        }
    }
}
