<?php

/**
 * Admin Styles
 *
 * @package _121Digital\Connect
 */

namespace _121Digital\Connect\Admin;

/**
 * AdminStyles Class
 *
 * Handles custom admin styling
 */
class AdminStyles
{
    /**
     * Register admin styles hooks
     *
     * @return void
     */
    public function register(): void
    {
        add_action('admin_enqueue_scripts', [$this, 'enqueueAdminStyles']);
        add_action('admin_head', [$this, 'removeHelpTabs']);
        add_action('admin_head', [$this, 'removeScreenTabs']);
    }

    private function shouldForceUI(): bool
    {
        if (current_user_can('REG121_User')) {
            return true;
        } elseif (defined('SC_FORCE_UI') && SC_FORCE_UI === true) {
            return true;
        } else {
            return false;
        }
    }

    public function removeHelpTabs(): void
    {
        $screen = get_current_screen();
        if (method_exists($screen, 'remove_help_tabs')) {
            $screen->remove_help_tabs(); // Removes the Help tab
        }
    }

    public function removeScreenTabs(): void
    {
        add_filter('screen_options_show_screen', '__return_false');
    }

    /**
     * Enqueue admin styles
     *
     * @return void
     */
    public function enqueueAdminStyles(): void
    {
        // only enque the admin styles if the current user is of type REG121_User
        if (!$this->shouldForceUI()) {
            return;
        }

        // Enqueue the admin styles
        wp_enqueue_style(
            'sc-admin-styles',
            SC_PLUGIN_URL . 'admin-styles.css',
            [],
            SC_PLUGIN_VERSION
        );
    }
}
