<?php

/**
 * Admin Bar Customization
 *
 * @package _121Digital\Connect
 */

namespace _121Digital\Connect\Admin;

/**
 * Admin Bar Class
 *
 * Handles admin bar customizations
 */
class AdminBar
{
    /**
     * Register admin bar modifications
     *
     * @return void
     */
    public function register(): void
    {
        add_action('admin_bar_menu', [$this, 'addCustomIcon'], 11);
        add_action('admin_head', [$this, 'addCustomStyles']);
        add_action('wp_head', [$this, 'addFrontendStyles']);
        add_action('wp_before_admin_bar_render', [$this, 'removeWpLogo'], 0);
        add_action('wp_enqueue_scripts', [$this, 'loadDashIcons']);
        add_action('wp_before_admin_bar_render', [$this, 'renameAdminUserMenu'], 1);
        add_action('wp_before_admin_bar_render', [$this, 'removeAdminBarComments'], 1);
        add_action('admin_bar_menu', [$this, 'removeAdminBarMySites'], 999);
    }

    public function loadDashIcons()
    {
        wp_enqueue_style('dashicons');
    }

    public function removeAdminBarComments(): void
    {
        global $wp_admin_bar;
        $wp_admin_bar->remove_menu('comments');
    }

    public function removeAdminBarMySites(): void
    {
        global $wp_admin_bar;
        $wp_admin_bar->remove_menu('my-sites');
    }

    /**
     * Rename "My Account" menu item to display user's avatar and name
     *
     * @return void
     */
    public function renameAdminUserMenu(): void
    {
        global $wp_admin_bar;

        if (is_user_logged_in()) {
            $user_id = get_current_user_id();
            $current_user = wp_get_current_user();
            $display_name = $current_user->display_name;

            // Change the "My Account" menu item
            // $userIcon = '<span class="dashicons dashicons-admin-users"></span>';
            $userIcon = '';
            $wp_admin_bar->add_node([
                'id'    => 'my-account',
                'title' => $userIcon . ' Your Account',
            ]);
        }
    }

    /**
     * Add custom icon to admin bar
     *
     * @param \WP_Admin_Bar $wpAdminBar
     * @return void
     */
    public function addCustomIcon($wpAdminBar): void
    {
        if (!is_user_logged_in()) {
            return;
        }

        $wpAdminBar->add_node([
            'id' => 'custom_admin_icon',
            'title' => '
                <span class="ab-icon">
                    <img src="' . SC_PLUGIN_URL . 'static/brand_icon.png">
                </span><span class="ab-label">REG121 Web Builder</span>',
            'href' => admin_url('options-general.php?page=site-connector'),
            'meta' => [
                'title' => 'Go to 121 Digital Connect',
            ],
        ]);
    }

    /**
     * Add custom styles for admin area
     *
     * @return void
     */
    public function addCustomStyles(): void
    {
        echo '<style>
            #wpadminbar #wp-admin-bar-custom_admin_icon .ab-icon:before {
                font-family: dashicons !important;
            }
            #wpadminbar #wp-admin-bar-custom_admin_icon {
                padding-left: 0 !important;
            }
            .ab-icon img {
                height: 25px !important;
            }
        </style>';
    }

    /**
     * Add custom styles for frontend
     *
     * @return void
     */
    public function addFrontendStyles(): void
    {
        if (is_admin_bar_showing()) {
            echo '<style>
                #wpadminbar #wp-admin-bar-custom_admin_icon .ab-icon:before {
                    font-family: dashicons !important;
                }
                #wpadminbar #wp-admin-bar-custom_admin_icon {
                    padding-left: 0 !important;
                }
                .ab-icon img {
                    height: 25px !important;
                }
            </style>';
        }
    }

    /**
     * Remove WordPress logo from admin bar
     *
     * @return void
     */
    public function removeWpLogo(): void
    {
        global $wp_admin_bar;
        $wp_admin_bar->remove_menu('wp-logo');
    }
}
