<?php
add_action('login_form', 'sc_custom_login_extra_button');
function sc_custom_login_extra_button()
{
    ?>
  <style>
    /* Modal overlay */
    #sc-login-modal-overlay {
      display: none;
      position: fixed;
      top: 0; left: 0;
      width: 100vw;
      height: 100vh;
      background: rgba(0, 0, 0, 0.6);
      z-index: 9999;
      justify-content: center;
      align-items: center;
    }

    /* Modal box */
    #sc-login-modal {
      width: 90%;
      max-width: 500px;
      height: 600px;
      background: white;
      border-radius: 10px;
      overflow: hidden;
      position: relative;
    }

    #sc-login-modal iframe {
      width: 100%;
      height: 100%;
      border: none;
    }

    /* Close button */
    #sc-login-close {
      position: absolute;
      top: 10px;
      right: 15px;
      background: #ccc;
      border: none;
      border-radius: 50%;
      width: 30px;
      height: 30px;
      cursor: pointer;
      font-weight: bold;
    }

    .sc-custom-login-button {
      display: flex;
      justify-content: left;
      margin-bottom: 15px;
    }

    .sc-custom-login-button button {
      background-color: #ff6600 !important;
      color: white !important;
      border: none !important;
      display: flex; /* Use flexbox */
      align-items: center; /* Center vertically */
      padding: 10px 15px; /* Add padding for better click area */
      cursor: pointer; /* Change cursor to pointer */
    }

    .sc-custom-login-button button img {
      height: 25px; /* Set height */
      margin-right: 8px; /* Add space between image and text */
    }
  </style>

<div class="sc-custom-login-button">
    <button type="button" class="button button-secondary" id="sc-login-popup-btn" style="display: flex; align-items: center; padding: 10px 15px; background-color: #ff6600; color: white; border: none;">
      <img src='<?php echo esc_url(SC_PLUGIN_URL . '/static/brand_icon_white.svg'); ?>' alt="Brand Icon" style="height: 25px; margin-right: 8px;">
      <span style="margin-top: 0;">Login with 121Digital</span>
    </button>
</div>


  <!-- Modal -->
  <div id="sc-login-modal-overlay">
    <div id="sc-login-modal">
      <button id="sc-login-close">&times;</button>
      <iframe id='sc-login-iframe' src="<?php print SC_REMOTE_BASE . '/embed/wp/wp_login.php'; ?>"></iframe>
    </div>
  </div>
  <?php
}

add_action('login_footer', 'sc_custom_login_modal_script');
function sc_custom_login_modal_script()
{
    ?>
  <script>
    const openBtn = document.getElementById('sc-login-popup-btn');
    const modalOverlay = document.getElementById('sc-login-modal-overlay');
    const closeBtn = document.getElementById('sc-login-close');
    const localLoginBtn = document.getElementById('sc-login-local-btn');
    const localLoginForm = document.getElementById('local-login-form');
    const loginIframe = document.getElementById('sc-login-iframe');

    openBtn.addEventListener('click', () => {
      <?php
          $siteId = get_option('sc_site_id');
    $iframeUrl = SC_REMOTE_BASE . '/embed/wp/wp_login.php?site_id=' . $siteId;
    ?>
      loginIframe.src = "<?php print $iframeUrl; ?>";
      modalOverlay.style.display = 'flex';
    });

    closeBtn.addEventListener('click', () => {
      modalOverlay.style.display = 'none';
    });

    // localLoginBtn.addEventListener('click', () => {
    //   localLoginForm.style.display = 'block';
    //   modalOverlay.style.display = 'none';
    // });

    // Listen for postMessage from iframe
    document.addEventListener('DOMContentLoaded', () => {
      window.addEventListener('message', (event) => {
        const { type, payload } = event.data || {};

        let action = "";
        if(event.data.action) {
          action = event.data.action;
        }

        if(type === "do_action" && payload == "close_window") {
          modalOverlay.style.display = 'none';
        }

        if(type === 'do_action' && action == 'redirect') {
            // Create a form
          const form = document.createElement('form');
          form.method = 'POST';
          // form.action = '<?php print site_url(); ?>/wp-json/sc/v1/key-auth';

          // Optional: add hidden fields to submit data
          const hiddenInput = document.createElement('input');
          hiddenInput.type = 'hidden';
          hiddenInput.name = 'payload'; // Replace with your actual key
          hiddenInput.value = payload; // Replace with your actual value
          form.appendChild(hiddenInput);

          // Append the form to the body
          document.body.appendChild(form);

          // Submit the form
          form.submit();
        }

        if (type === '121digital-login-success') {
          console.log('Login success from iframe:', payload);
          window.location.href = '/wp-admin';
        }
      });
    });
  </script>
  <?php
}
