<?php

/**
 * Abstract base class for all command classes in the SC framework.
 *
 * This class provides a structure for executing commands with arguments.
 * Child classes should implement the `execute()` method with their specific logic.
 */
abstract class SC_Command_Base
{
    /**
     * The arguments passed to the command.
     *
     * @var array
     */
    protected $args;

    /**
     * Constructor to initialize the command with arguments.
     *
     * @param array $args Optional associative array of arguments.
     */
    public function __construct(array $args = [])
    {
        $this->args = $args;
    }

    /**
     * Execute the command.
     *
     * Child classes must implement this method.
     *
     * @return mixed
     */
    abstract public function execute();

    /**
     * Get all arguments passed to the command.
     *
     * @return array The command arguments.
     */
    protected function get_args()
    {
        return $this->args;
    }

    /**
     * Set or update the arguments for the command.
     *
     * @param array $args Associative array of new arguments.
     * @return void
     */
    public function set_args(array $args = [])
    {
        $this->args = $args;
    }
}
