<?php

namespace _121Digital\Connect\Network;

use _121Digital\Connect\Core\Environment;
use _121Digital\Connect\Network\Modules\NetworkCookies;
use _121Digital\Connect\User\UserRoles;

class Network
{
    private array $networkAdminWpSubmodule = [
      NetworkDashboard::class,
      NetworkMenu::class,
      NetworkSiteNew::class,
      NetworkBar::class,
      NetworkViewSite::class
    ];

    private array $networkModuleSubModuls = [
      NetworkCookies::class
    ];

    public function register(): void
    {
        // this module should only be active in a multisite node context and admins..
        if (!Environment::isMultisiteNode() || !UserRoles::isContextAdministrator()) {
            return;
        }

        // only load UI / admin submodules when in network admin
        if (is_network_admin()) {
            $this->loadNetworkAdminWpSubmodules();
            $this->loadNetworkModuleSubmodules();
        }
    }

    private function loadNetworkAdminWpSubmodules(): void
    {
        foreach ($this->networkAdminWpSubmodule as $submoduleClass) {
            $submodule = new $submoduleClass();
            $submodule->register();
        }
    }

    private function loadNetworkModuleSubmodules(): void
    {
        foreach ($this->networkModuleSubModuls as $submoduleClass) {
            $submodule = new $submoduleClass();
            $submodule->register();
        }
    }
}
