<?php

namespace _121Digital\Connect\Network\Modules;

class NetworkCookies
{
    public static function register(): void
    {
        add_filter('send_auth_cookies', [self::class, 'sendAuthCookies']);
    }

    /**
     * Append site ID to cookie names to avoid conflicts in multisite setups
     * @return array<string, mixed> Modified cookies array
     */
    public function sendAuthCookies(): array
    {
        $current_site = get_current_blog_id();

        //append site ID to cookie names, to avoid conflicts in multisite setups
        foreach ($cookies as $key => $cookie) {
            $cookies[$key]['name'] .= "_site{$current_site}";
        }
        return $cookies;
    }
}
