import { defineConfig } from 'vite'
import react from '@vitejs/plugin-react'
import { resolve } from 'path'

export default defineConfig({
  plugins: [react()],
  build: {
    outDir: 'assets',
    emptyOutDir: false,
    rollupOptions: {
      input: resolve(__dirname, 'src/js/react/index.jsx'),
      output: {
        format: 'iife',
        dir: 'assets',
        entryFileNames: 'main.js',
        assetFileNames: (assetInfo) => {
          // Font files should be in root assets folder with original names
          if (assetInfo.name && /\.(woff2?|ttf|otf|eot)$/i.test(assetInfo.name)) {
            return '[name][extname]'
          }
          // CSS and other assets use main prefix
          return 'main.[ext]'
        },
        name: 'envatoElements',
        inlineDynamicImports: true
      }
    },
    cssCodeSplit: false,
    minify: false,
    sourcemap: true,
    chunkSizeWarningLimit: 10000
  },
  css: {
    preprocessorOptions: {
      scss: {
        // SCSS files already have their own imports
      }
    }
  },
  resolve: {
    alias: {
      '@': resolve(__dirname, 'src')
    }
  },
  server: {
    port: 3000,
    host: true
  }
})
