import { defineConfig } from 'vite'
import react from '@vitejs/plugin-react'
import { resolve } from 'path'

export default defineConfig({
  plugins: [react()],
  build: {
    outDir: 'assets',
    emptyOutDir: false,
    rollupOptions: {
      input: resolve(__dirname, 'src/js/react/elements-deep.jsx'),
      output: {
        format: 'iife',
        dir: 'assets',
        entryFileNames: 'elements_deep.js',
        assetFileNames: 'elements_deep.[ext]',
        name: 'envatoElementsDeep',
        inlineDynamicImports: true
      }
    },
    cssCodeSplit: false,
    minify: false,
    sourcemap: true
  },
  css: {
    preprocessorOptions: {
      scss: {}
    }
  },
  resolve: {
    alias: {
      '@': resolve(__dirname, 'src')
    }
  }
})

