import { defineConfig } from 'vite'
import react from '@vitejs/plugin-react'
import { resolve } from 'path'

export default defineConfig({
  plugins: [react()],
  build: {
    outDir: 'assets',
    emptyOutDir: false,
    rollupOptions: {
      input: resolve(__dirname, 'src/js/elementor-modal/index.js'),
      output: {
        format: 'iife',
        dir: 'assets',
        entryFileNames: 'elementor_modal.js',
        assetFileNames: 'elementor_modal.[ext]',
        name: 'envatoElementorModal',
        inlineDynamicImports: true
      }
    },
    cssCodeSplit: false,
    minify: false,
    sourcemap: true
  },
  css: {
    preprocessorOptions: {
      scss: {}
    }
  },
  resolve: {
    alias: {
      '@': resolve(__dirname, 'src')
    }
  }
})

