import { useState, useEffect } from 'react'
import { apiCall } from './apiHelper'

const verifyExtensionsToken = ({ token }) => {
  const [loading, setLoading] = useState(true)
  const [data, setData] = useState(null)
  const [error, setError] = useState(null)

  useEffect(() => {
    if (!token) {
      setLoading(false)
      return
    }

    const verify = async () => {
      try {
        setLoading(true)
        setError(null)
        const result = await apiCall('verifyExtensionsToken', 'POST', { token })
        setData(result)
        setLoading(false)
      } catch (err) {
        setError(err.message)
        setLoading(false)
      }
    }

    verify()
  }, [token])

  return { loading, data, error }
}

export default verifyExtensionsToken


