import { useState, useEffect } from 'react'
import { apiCall } from './apiHelper'

/**
 * Install a premium template kit from Envato Elements
 * Endpoint: installPremiumTemplateKit
 * @param {string} templateKitId - The template kit ID to install
 */
const installPremiumTemplateKit = ({ templateKitId }) => {
  const [loading, setLoading] = useState(true)
  const [data, setData] = useState(null)
  const [error, setError] = useState(null)

  useEffect(() => {
    if (!templateKitId) {
      setLoading(false)
      return
    }

    const install = async () => {
      try {
        setLoading(true)
        setError(null)
        const result = await apiCall('installPremiumTemplateKit', 'POST', { templateKitId })
        setData(result)
        setLoading(false)
      } catch (err) {
        setError(err.message)
        setLoading(false)
      }
    }

    install()
  }, [templateKitId])

  return { loading, data, error }
}

export default installPremiumTemplateKit


