import { useState, useEffect } from 'react'
import { apiCall } from './apiHelper'

const importSingleTemplate = ({ templateKitId, templateId, importAgain = false, insertToPage = false }) => {
  const [loading, setLoading] = useState(true)
  const [data, setData] = useState(null)
  const [error, setError] = useState(null)

  useEffect(() => {
    if (!templateKitId || templateId === null || templateId === undefined) {
      setLoading(false)
      return
    }

    const importTemplate = async () => {
      try {
        setLoading(true)
        setError(null)
        console.log('Importing template:', { templateKitId, templateId, importAgain, insertToPage })
        const result = await apiCall('importSingleTemplate', 'POST', { 
          templateKitId, 
          templateId,
          importAgain,
          insertToPage 
        })
        console.log('Import result:', result)
        setData(result)
        setLoading(false)
      } catch (err) {
        console.error('Import error:', err)
        setError(err.message)
        setLoading(false)
      }
    }

    importTemplate()
  }, [templateKitId, templateId, importAgain, insertToPage])

  return { loading, data, error }
}

export default importSingleTemplate


