import { useState, useEffect } from 'react'
import { apiCall } from './apiHelper'

const importFreeBlock = ({ blockId }) => {
  const [loading, setLoading] = useState(true)
  const [data, setData] = useState(null)
  const [error, setError] = useState(null)

  useEffect(() => {
    if (!blockId) {
      setLoading(false)
      return
    }

    const importBlock = async () => {
      try {
        setLoading(true)
        setError(null)
        const result = await apiCall('importFreeBlock', 'POST', { blockId })
        setData(result)
        setLoading(false)
      } catch (err) {
        setError(err.message)
        setLoading(false)
      }
    }

    importBlock()
  }, [blockId])

  return { loading, data, error }
}

export default importFreeBlock


