import { useState, useEffect } from 'react'
import { apiCall } from './apiHelper'

const fetchFreeBlockSearchResults = ({ searchTerm, page }) => {
  const [loading, setLoading] = useState(true)
  const [data, setData] = useState(null)
  const [error, setError] = useState(null)

  useEffect(() => {
    const fetch = async () => {
      try {
        setLoading(true)
        setError(null)
        const result = await apiCall('fetchFreeBlockSearchResults', 'POST', { searchTerm, page })
        setData(result)
        setLoading(false)
      } catch (err) {
        setError(err.message)
        setLoading(false)
      }
    }

    fetch()
  }, [searchTerm, page])

  return { loading, data, error }
}

export default fetchFreeBlockSearchResults


