<?php

namespace _121Digital\Connect\Google\Admin;

class GoogleAdminMenu
{
    public function register(): void
    {
        add_action('admin_menu', [$this, 'renameGoogleSiteKitAdminMenu'], 999);
    }

    public function renameGoogleSiteKitAdminMenu(): void
    {
        global $menu;

        foreach ($menu as $key => $item) {
            // Check multiple possible Google Site Kit menu identifiers
            if (isset($item[2]) && (
                $item[2] === 'google-site-kit' ||
                $item[2] === 'googlesitekit-dashboard' ||
                $item[2] === 'toplevel_page_googlesitekit-dashboard' ||
                strpos($item[2], 'googlesitekit') !== false
            )) {
                $menu[$key][0] = 'Google';
                break;
            }

            // Alternative check by menu title if slug check fails
            if (isset($item[0]) && (
                strpos($item[0], 'Site Kit') !== false ||
                strpos($item[0], 'Google Site Kit') !== false
            )) {
                $menu[$key][0] = 'Google';
                break;
            }
        }
    }
}
