<?php

/**
 * Get Users Command
 *
 * @package _121Digital\Connect
 */

namespace _121Digital\Connect\Commands\Users;

use _121Digital\Connect\Commands\CommandBase;

/**
 * Command to get all WordPress users and their metadata.
 */
class Get extends CommandBase
{
    /**
     * Execute the command to get all users.
     *
     * @return array An associative array containing the result of the command execution.
     */
    public function execute(): array
    {
        require_once ABSPATH . 'wp-includes/user.php';

        $users = get_users();
        $userData = [];

        foreach ($users as $user) {
            $userData[] = [
                'ID' => $user->ID,
                'user_login' => $user->user_login,
                'user_email' => $user->user_email,
                'first_name' => get_user_meta($user->ID, 'first_name', true),
                'last_name' => get_user_meta($user->ID, 'last_name', true),
                'display_name' => $user->display_name,
                'role' => implode(', ', $user->roles),
            ];
        }

        return $this->success('All users retrieved successfully.', $userData);
    }
}
