<?php

/**
 * Matomo Has Tracker Command
 *
 * @package _121Digital\Connect
 */

namespace _121Digital\Connect\Commands\Matomo;

use _121Digital\Connect\Commands\CommandBase;

/**
 * Command to check if Matomo tracking code is installed.
 */
class HasTracker extends CommandBase
{
    /**
     * Execute the command to check for Matomo tracker.
     *
     * @return array An associative array with the result of the command execution.
     */
    public function execute(): array
    {
        try {
            if (!function_exists('sc_matomo_has_tracking_code')) {
                throw new \Exception('Matomo tracking functions not available.');
            }

            $hasTracker = sc_matomo_has_tracking_code();
            $trackingCode = sc_matomo_get_tracking_code();
            $trackingCodeCanRender = sc_matomo_can_render_tracking_code();

            return $this->success(
                'The plugin has verified if the site has a tracking code installed.',
                [
                    'has_tracker' => $hasTracker,
                    'tracking_code' => $trackingCode,
                    'security_pass' => $trackingCodeCanRender,
                ]
            );
        } catch (\Exception $e) {
            return $this->error('The plugin could not verify if the site has a tracking code installed.');
        }
    }
}
