<?php

namespace _121Digital\Connect\Admin;

use _121Digital\Connect\User\UserRoles;

class Tools
{
    public function register(): void
    {
        add_action('admin_menu', [$this, 'removeToolsMenu']);
        add_action('admin_init', [$this, 'blockToolsPageAccess']);
    }

    public function removeToolsMenu(): void
    {
        // only remove the tools menu for users with the REG121_User role
        if (!current_user_can('reg121_user') || UserRoles::isContextAdministrator()) {
            return;
        }

        remove_menu_page('tools.php');
    }

    public function blockToolsPageAccess()
    {
        // only block access to the tools page for users with the REG121_User role
        if (!current_user_can('reg121_user') || UserRoles::isContextAdministrator()) {
            return;
        }

        global $pagenow;
        if ($pagenow === 'tools.php') {
            wp_redirect(admin_url());
            exit;
        }
    }
}
