<?php

namespace _121Digital\Connect\Admin\Themes;

use _121Digital\Connect\User\UserRoles;

class ThemesMenueItem
{
    public function register(): void
    {
        add_action('admin_menu', [$this, 'removeThemesMenuItem'], 999);
        add_action('admin_init', [$this, 'blockThemesPageAccess']);
    }

    public function removeThemesMenuItem(): void
    {
        if (!UserRoles::isContextUser()) {
            return;
        }

        remove_menu_page('themes.php');
    }

    public function blockThemesPageAccess(): void
    {
        if (!UserRoles::isContextUser()) {
            return;
        }

        global $pagenow;
        if ($pagenow === 'themes.php') {
            wp_redirect(admin_url());
            exit;
        }
    }
}
