<?php

namespace _121Digital\Connect\Admin\Themes;

class Themes
{
    private array $submodules = [
      ThemesMenueItem::class,
    ];

    private array $components = [];

    public function register(): void
    {
        $this->registerSubmodules();
    }

    private function registerSubmodules(): void
    {
        foreach ($this->submodules as $class) {
            try {
                if (! class_exists($class)) {
                    // Skip missing classes to avoid fatal errors.
                    continue;
                }

                $instance = new $class();

                if (method_exists($instance, 'register')) {
                    $instance->register();
                }

                $short = (new \ReflectionClass($class))->getShortName();
                $this->components[ $short ] = $instance;
            } catch (\Throwable $e) {
                // Throw error through pugin error handling.
                Plugin::die($e->getMessage());
            }
        }
    }
}
