<?php
/**
 * Modern Icons Enhancement
 *
 * @package _121Digital\Connect
 */

namespace _121Digital\Connect\Admin;

/**
 * ModernIcons Class
 *
 * Enhances WordPress admin with modern icons and visual elements
 */
class ModernIcons
{
    /**
     * Register icon hooks
     *
     * @return void
     */
    public function register(): void
    {
        add_action('admin_enqueue_scripts', [$this, 'enqueueIconStyles']);
        add_action('admin_head', [$this, 'addCustomIconStyles']);
        add_action('admin_menu', [$this, 'addCustomMenuIcons'], 999);
    }

    /**
     * Enqueue icon styles
     *
     * @return void
     */
    public function enqueueIconStyles(): void
    {
        if (!$this->shouldForceUI()) {
            return;
        }

        wp_enqueue_style(
            'modern-icons',
            SC_PLUGIN_URL . 'src/Admin/modern-icons.css',
            ['sc-admin-styles'],
            SC_PLUGIN_VERSION
        );
    }

    /**
     * Add custom icon styles
     *
     * @return void
     */
    public function addCustomIconStyles(): void
    {
        if (!$this->shouldForceUI()) {
            return;
        }
        ?>
        <style>
        /* Custom icon enhancements */
        #adminmenu .wp-menu-image:before {
            font-family: 'dashicons' !important;
            font-size: 18px !important;
            width: 20px !important;
            height: 20px !important;
            margin-right: 12px !important;
            vertical-align: middle !important;
            transition: all 0.2s ease !important;
        }

        /* Custom icons for specific menu items */
        #adminmenu .toplevel_page_design-overview .wp-menu-image:before {
            content: '\f100' !important; /* dashicons-art */
            color: #667eea !important;
        }

        #adminmenu .menu-top[href*="edit.php"] .wp-menu-image:before {
            content: '\f109' !important; /* dashicons-edit */
            color: #28a745 !important;
        }

        #adminmenu .menu-top[href*="upload.php"] .wp-menu-image:before {
            content: '\f104' !important; /* dashicons-admin-media */
            color: #17a2b8 !important;
        }

        #adminmenu .menu-top[href*="edit-comments.php"] .wp-menu-image:before {
            content: '\f101' !important; /* dashicons-admin-comments */
            color: #ffc107 !important;
        }

        #adminmenu .menu-top[href*="themes.php"] .wp-menu-image:before {
            content: '\f100' !important; /* dashicons-admin-appearance */
            color: #6f42c1 !important;
        }

        #adminmenu .menu-top[href*="plugins.php"] .wp-menu-image:before {
            content: '\f106' !important; /* dashicons-admin-plugins */
            color: #e83e8c !important;
        }

        #adminmenu .menu-top[href*="users.php"] .wp-menu-image:before {
            content: '\f110' !important; /* dashicons-admin-users */
            color: #fd7e14 !important;
        }

        #adminmenu .menu-top[href*="tools.php"] .wp-menu-image:before {
            content: '\f107' !important; /* dashicons-admin-tools */
            color: #20c997 !important;
        }

        #adminmenu .menu-top[href*="options-general.php"] .wp-menu-image:before {
            content: '\f111' !important; /* dashicons-admin-settings */
            color: #6c757d !important;
        }

        /* Hover effects for icons */
        #adminmenu a:hover .wp-menu-image:before {
            transform: scale(1.1) !important;
        }

        #adminmenu .current .wp-menu-image:before,
        #adminmenu .wp-has-current-submenu .wp-menu-image:before {
            transform: scale(1.1) !important;
        }

        /* Custom icon for admin bar */
        #wpadminbar #wp-admin-bar-wp-logo .ab-icon:before {
            content: '\f120' !important; /* dashicons-wordpress */
            color: #ffffff !important;
            font-size: 20px !important;
        }

        /* Dashboard widget icons */
        .postbox .hndle:before {
            content: '\f111' !important; /* dashicons-admin-settings */
            font-family: 'dashicons' !important;
            margin-right: 8px !important;
            color: #667eea !important;
        }

        #modern_welcome_widget .hndle:before {
            content: '\f119' !important; /* dashicons-welcome-write-blog */
        }

        #quick_actions_widget .hndle:before {
            content: '\f164' !important; /* dashicons-admin-tools */
        }

        #site_overview_widget .hndle:before {
            content: '\f226' !important; /* dashicons-chart-bar */
        }

        /* Button icons */
        .button-primary:before {
            content: '\f147' !important; /* dashicons-yes */
            font-family: 'dashicons' !important;
            margin-right: 5px !important;
        }

        .button-secondary:before {
            content: '\f132' !important; /* dashicons-arrow-right */
            font-family: 'dashicons' !important;
            margin-right: 5px !important;
        }

        /* Form field icons */
        .form-table th:before {
            content: '\f111' !important; /* dashicons-admin-settings */
            font-family: 'dashicons' !important;
            margin-right: 8px !important;
            color: #667eea !important;
            font-size: 14px !important;
        }

        /* Table action icons */
        .row-actions .edit a:before {
            content: '\f464' !important; /* dashicons-edit */
            font-family: 'dashicons' !important;
            margin-right: 3px !important;
        }

        .row-actions .trash a:before {
            content: '\f182' !important; /* dashicons-trash */
            font-family: 'dashicons' !important;
            margin-right: 3px !important;
        }

        .row-actions .view a:before {
            content: '\f177' !important; /* dashicons-visibility */
            font-family: 'dashicons' !important;
            margin-right: 3px !important;
        }

        /* Notice icons */
        .notice-success:before {
            content: '\f147' !important; /* dashicons-yes */
            font-family: 'dashicons' !important;
            color: #28a745 !important;
            font-size: 16px !important;
            margin-right: 8px !important;
        }

        .notice-error:before {
            content: '\f158' !important; /* dashicons-dismiss */
            font-family: 'dashicons' !important;
            color: #dc3545 !important;
            font-size: 16px !important;
            margin-right: 8px !important;
        }

        .notice-warning:before {
            content: '\f227' !important; /* dashicons-warning */
            font-family: 'dashicons' !important;
            color: #ffc107 !important;
            font-size: 16px !important;
            margin-right: 8px !important;
        }

        .notice-info:before {
            content: '\f348' !important; /* dashicons-info */
            font-family: 'dashicons' !important;
            color: #17a2b8 !important;
            font-size: 16px !important;
            margin-right: 8px !important;
        }

        /* Tab icons */
        .nav-tab:before {
            content: '\f111' !important; /* dashicons-admin-settings */
            font-family: 'dashicons' !important;
            margin-right: 5px !important;
            font-size: 14px !important;
        }

        .nav-tab.nav-tab-active:before {
            color: #667eea !important;
        }

        /* Screen options and help icons */
        #screen-options-link:before {
            content: '\f111' !important; /* dashicons-admin-settings */
            font-family: 'dashicons' !important;
            margin-right: 5px !important;
        }

        #contextual-help-link:before {
            content: '\f223' !important; /* dashicons-editor-help */
            font-family: 'dashicons' !important;
            margin-right: 5px !important;
        }

        /* Media library icons */
        .attachment .thumbnail:before {
            content: '\f104' !important; /* dashicons-admin-media */
            font-family: 'dashicons' !important;
            position: absolute;
            top: 50%;
            left: 50%;
            transform: translate(-50%, -50%);
            font-size: 24px;
            color: #6c757d;
        }

        /* Custom scrollbar with icon */
        #adminmenu::-webkit-scrollbar-thumb:before {
            content: '\f140' !important; /* dashicons-arrow-up */
            font-family: 'dashicons' !important;
            color: #667eea !important;
            font-size: 12px !important;
        }
        </style>
        <?php
    }

    /**
     * Add custom menu icons
     *
     * @return void
     */
    public function addCustomMenuIcons(): void
    {
        if (!$this->shouldForceUI()) {
            return;
        }

        // Add custom icons to existing menu items
        add_filter('admin_menu', [$this, 'customizeMenuIcons'], 999);
    }

    /**
     * Customize menu icons
     *
     * @param array $menu
     * @return array
     */
    public function customizeMenuIcons($menu): array
    {
        // This is handled in the CSS above
        return $menu;
    }

    /**
     * Check if UI should be forced
     *
     * @return bool
     */
    private function shouldForceUI(): bool
    {
        if (current_user_can('REG121_User')) {
            return true;
        } elseif (defined('SC_FORCE_UI') && SC_FORCE_UI === true) {
            return true;
        } else {
            return false;
        }
    }
}
