<?php

namespace _121Digital\Connect\Admin\Favicon;

use _121Digital\Connect\Core\Plugin;

class Favicon
{
    public function register()
    {
        add_action('admin_head', [__CLASS__, 'addFavicon']);
        add_action('wp_head', [__CLASS__, 'addFavicon']);
    }

    public static function addFavicon(): void
    {
        $pluginUrl = Plugin::getInstance()->getConfig('plugin_url');
        $favicon_url = $pluginUrl . '/static/brand_icon.png';

        echo '<link rel="shortcut icon" href="' . esc_url($favicon_url) . '" />';
    }
}
